<?php
  // PHP-Fehlermeldungen unterbinden
    error_reporting(0); // Alle Fehlermeldungen aktivieren '6143' 

  $Path = str_replace('\\','/', __FILE__);
  $Path = str_replace('frontend/calendar_current-month.php', '', $Path);

  include_once($Path."gigkalender.ini.php");
  include_once($Path."includes/funktionen.php");
  include_once($Path."functions/attributes.php");

  $language = getSetup(SetupFrontendLanguage);
  if ($language == '') { $language = 'english'; }
  $language = $Path.'languages/'.$language.'.php';
  include($language);
  
  if (isset($_REQUEST['month'])) { $monat=$_REQUEST['month']; }
  else { $monat = date("n"); }
  if (isset($_REQUEST['year'])) { $Jahr=$_REQUEST['year']; }
  else { $Jahr = date("Y"); }

  $ErsterWochentag = WochentagVonDatum (1, $monat, $Jahr);
  $TimestampVonHeute = TimestampAusDatum(date("d"), date("m"), date("y"));
  $Tag = 1;
  $Zelle = 1;
  $AnzahlTagedesMonats = AnzahlTagedesMonats ($monat, $Jahr);
  
  $MonthBackwards = $monat-1;
  $YearBackwards = $Jahr;
  if ( $MonthBackwards == '0') 
  {
    $MonthBackwards = '12';
    $YearBackwards  = $Jahr-1;
  }
  
  $MonthForwards = $monat+1;
  $YearForwards = $Jahr;
  if ( $MonthForwards == '13') 
  {
    $MonthForwards = '1';
    $YearForwards  = $Jahr+1;
  }
  
  echo '<div id="CalendarCurrentMonth">
        <table summary="CalendarCurrentMonth">
          <tr>
            <td class="NavigationBackwards"><a href="'.$_SERVER['PHP_SELF'].'?year='.$YearBackwards.'&amp;month='.$MonthBackwards.'">&laquo;</a></td>
            <td class="Month" colspan="5">'.MonatsNameVonDatum ($monat).' '.$Jahr.'</td>
            <td class="NavigationForwards"><a href="'.$_SERVER['PHP_SELF'].'?year='.$YearForwards.'&amp;month='.$MonthForwards.'">&raquo;</a></td>
          </tr>
          <tr id="Weekdays">
            <td>'.$L_Mo.'</td>
            <td>'.$L_Tu.'</td>
            <td>'.$L_We.'</td>
            <td>'.$L_Th.'</td>
            <td>'.$L_Fr.'</td>
            <td>'.$L_Sa.'</td>
            <td>'.$L_Su.'</td>
          </tr>
          <tr>';
          
  for ($z=1; $z<=6; $z++)
      {
        for ($s=1; $s<=7; $s++)
        {
          if (($Zelle < $ErsterWochentag) OR ($Tag > $AnzahlTagedesMonats)) {echo "<td>\n</td>";}
          else
          {
            $Timestamp = TimestampAusDatum($Tag, $monat, $Jahr);
            $StatusDesTages = CheckStatusDesTages($Timestamp);            

            echo '<td>';
            echo '<span class="'.WochentagsNameVonDatum ($Tag, $monat, $Jahr).'">';
            if ($Timestamp == $TimestampVonHeute) { echo '<span class="Today">'; }
            
            if ($StatusDesTages == "L_GigStatus1")
            {
              echo '<span class="Gig">';
            }                
            
            // Wochentags-Zahl mit Link
            if ( $StatusDesTages != "L_GigStatus1")
            { 
              echo $Tag;
            }
            else
            {
              $ToolTip = GetTooltip($Timestamp);
              echo '<a href="calendar_showGigDetails.php?timestamp='.$Timestamp.'" title="'.$ToolTip.'">'.$Tag.'</a>';              
            }
            if ($StatusDesTages == "L_GigStatus1") { echo '</span>'; }
            if ($Timestamp == $TimestampVonHeute) {echo "</span>"; }
            echo "</span>";
            echo "</td>\n";
            $Tag++;
          }
          if ($s == "7")
          {
            if ($z < "6")
            {
              echo "</tr><tr>";
 	   }
            else
            {
              echo "</tr>";
            }
          }
          $Zelle++;
        }
      }
          
  echo '</table></div>';
?>