// Version 1.0
// Updated:
// Sunday, March 23, 2008
// Fuzzing
// Adam Knutson, Rene Schmidt
//
// ==UserScript==
// @name Fuzzing
// @license GPL 2.0
// @description Fuzzing for websites and webapps. Just press CTRL + SHIFT + F! Based on "Random Filler"  by Adam Knutson
// ==/UserScript==

function fuzzing() {

	// Menus
	var selectMenus = document.getElementsByTagName('select');

	// The menu section.
	if (selectMenus.length) {
		// if there is atleast one menu on the page
		// then change the value of all of them.
		for (var i = 0; i < selectMenus.length; i++) {
			// Number of choices in the menu
			var choiceNum = selectMenus[i].length;
			// Select a random number between 0 and the (number of choices - 1)
			var newIndex = Math.round((Math.random() * (choiceNum - 1)));
			if (newIndex == 0) {
				// Lets make sure the menu doesn't stay on the default value
				// which is usually 0.
				newIndex = newIndex + 1;
			}

			// Change the selection.
			selectMenus[i].selectedIndex = newIndex;
		}
	}

	// The Checkbox/Radio/Text Section
  var inputElements = document.getElementsByTagName('input');
  
	var groupCount = 0;
	var groupStart = 0;

	if (inputElements.length) {
		// if there is atleast one input element on the page
		// then change the value of all of them.
		for (var i = 0; i < inputElements.length; i++) {

      // Sometimes the form attribute is missing; handle it
      var formName = inputElements[0].form.name ? inputElements[i].form.name : "";

			var groupName = inputElements[i].name;
			// var currentGroup = document.forms[formName].elements[groupName];

			var form = document.forms.namedItem(formName);

			// radio boxes
			if (inputElements[i].type == 'radio') {

				if (i == 0 || groupCount == 0 || groupName == previousName) {
					// then add one to the count.
					groupCount = groupCount + 1;
					var previousName = groupName;

					// //// this could potentially cause a problem
					// //// if there is no i + 1:
					if (inputElements[i + 1].name != groupName) {
						// if the next element is a different group
						// select a value for this group, and reset
						// the count.

						// the lowest numbered element we can select in this
						// group
						var minRange = ((i + 1) - groupCount);

						// randomize the selection
						var selection = Math
								.round((Math.random() * (groupCount - 1)));

						// select a value anywhere from minRange to minRange +
						// selection.
						inputElements[minRange + selection].checked = true;

						groupCount = 0;
					}
				}
			}
			// checkboxes
			else if (inputElements[i].type == 'checkbox') {
				// either select a checkbox or don't. randomize.
				var selectDecision = Math.round((Math.random() * 1));
				if (selectDecision == 1) {
					// if random number is 1 then select box.
					if (inputElements[i].checked) {
						// if the box is already checked, uncheck it.
						inputElements[i].checked = false;
					} else {
						// otherwise check the box.
						inputElements[i].checked = true;
					}
				}
			} else if (inputElements[i].type.match(/^(text|password)$/)) {
				var len = 32, s = "";

				for (var m = 0; m < len; m++) {
					s += String.fromCharCode(Math.floor(Math.random()*222)+32);
				}
				inputElements[i].value = s;
			}
		}
	}
  
	// The Text area Section
  var textareaElements = document.getElementsByTagName('textarea');
  
	if (textareaElements.length) {
		// if there is atleast one textarea element on the page
		// then change the value of all of them.
		for (var i = 0; i < textareaElements.length; i++) {
				var len = 1024, s = "";

				for (var m = 0; m < len; m++) {
					s += String.fromCharCode(Math.floor(Math.random()*222)+32);
				}
				textareaElements[i].value = s;
		}
	}
}

// The listener section

// a constant variable for the F Key.
var F_KEY = 70;

function keyPressed(e) {
	// If you press CTRL, SHIFT, F
	// Fill out the form.
	if (e.ctrlKey && e.shiftKey && e.keyCode == F_KEY) {
		fuzzing();
	}
}

// listen for keypresses
window.addEventListener('keydown', keyPressed, false);
