<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/
  session_name('GigKalender');
  session_start();
  $session_id = session_id();

  include("includes/error_reporting.php");
  header("content-type: text/html; charset=utf-8");
  include("gigkalender.ini.php");
  include("functions/standard.php");
  // Variablen definieren
    foreach ($_REQUEST as $key => $value)
    {
      if (get_magic_quotes_gpc() AND !is_array($value)) $$key = stripslashes($value);
      else $$key = $value;
    }
    foreach ($_POST as $key => $value)
    {
      if (get_magic_quotes_gpc() AND !is_array($value)) $$key = stripslashes($value);
      else $$key = $value;
    }
  // Login
    if (isset($_POST['login']))
    {
      $userid=getUID($_POST['username'], $_POST['userpass']);
      if ($userid==true) { login($userid); }
    }
    else
    {
      logoutInactiveUser();
    }

  include('includes/backend_language_selector.php');

  // Fehlermeldung ausgeben
    $Message = '';
    if (isset($_POST['login']))
    {
      $userid=getUID($_POST['username'], $_POST['userpass']);
      if (!$userid) { $Message = '<div class="Fehlermeldung">'.$L_071.'</div>'; }
    }

  // Logout
    if (isset($_POST['logout']))
    {
      logout();
      $Message = '<div class="Fehlermeldung">'.$L_004.'</div>';
    }

  $timer = startTime();

  if (isset($_REQUEST['submenue'])) { $Submenue = $_REQUEST['submenue']; }
  else { $Submenue = "calendar"; }

  if (isset($_REQUEST['inhalt'])) { $Inhalt = $_REQUEST['inhalt']; }
  else
  {
    switch ( $Submenue )
    {
      case "calendar": $Inhalt ="backend_showAllGigs"; break;
      case "news": $Inhalt ="backend_showAllNews"; break;
      case "guestbook": $Inhalt ="backend_showAllGuestbookEntries"; break;
      case "filesharing": $Inhalt ="downloadMidiFiles"; break;
      case "user": $Inhalt ="editCurrentUser"; break;
      case "mail": $Inhalt ="mail"; break;
      case "admin": $Inhalt ="setup"; break;
      case "cms": $Inhalt ="menu"; break;
      case "help": $Inhalt ="forum"; break;
    }
  }
  include ('includes/header.php');
  // JavaScript einbinden
    if ( $Inhalt=='backend_addNews' ) include ('editor/editor.php');
    if ( $Inhalt=='addPage' ) include ('editor/editor2.php');
    if ( $Inhalt=='backend_addGig' AND getSetup('SetupShowEditorInAddGigForm') ) include ('editor/editor.php');
    if ( $Inhalt=='setup') include ('admin/includes/setup/javascript.php');
    if ( $Inhalt=='addUser') include ('admin/includes/addUser/javascript.php');
    if ( $Inhalt=='backend_addGig') include ('calendar/includes/addGig/javascript.php');
    if ( $Inhalt=='backend_addGig') include ('calendar/includes/addGig/autocomplete/autocomplete.php');
    if ( $Inhalt=='editCurrentUser') include ('admin/includes/addUser/javascript.php');

  // Updating MySQL Datebase if update file is present
    if (is_file("update.sql.php")) include("update.sql.php");

    ?>
    </head>
  <body>
    <div id="Box">
      <div class="Head">
        <div class="Title"><img src="images/gigkalender-logo.gif" alt="GigKalender-Logo" /></div>
        <div class="Login">
          <?php echo $Message; include("includes/login.php"); ?></div>
      </div>
      <div id="Box_Navigation">
        <?php
          if (loggedIn())
  	      {
            include("includes/menue.php");
            echo '<br style="clear: left;" />';
            if ($Submenue!="") { include "submenues/".$Submenue.".php"; }
            echo '<br style="clear: left;" />';
          }
        ?>
      </div>
      <div id="Box_Inhalt">
        <?php
          if (loggedIn())
  	      {
            if ($Inhalt!="") { include($Submenue.'/'.$Inhalt.'.php'); }
          }
          echo '<br style="clear: left;" />';
        ?>
      </div>
      <div id="Box_Footer">
        <?php include("includes/footer.php"); ?>
      </div>
    </div>
  </body>
</html>