<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/

function getGuestbookBackEndPagination():string {
  global $AnzahlSeiten;
  if ($AnzahlSeiten>'1') {
    global $aktuelleSeite;
    $output = '<div class="GigNavigation">';
    $URL = "index.php?submenue=guestbook&content=backend_showAllGuestbookEntries";
    $output .= getPagination ($URL, $AnzahlSeiten, $aktuelleSeite, "ASC", "page");
    $output .= '</div>'; }
  else $output = '';
  return $output; }

function editGuestbookEntry($ID, $Name, $Email, $URL, $ICQ, $Nachricht, $Ort, $Kommentar):BOOL {
  $arg_list = get_defined_vars();
  global $prefix;
  global $db;
  // Optimize function arguments
    foreach($arg_list as $key => $value) {
      $$key = html_entity_decode($$key);
      $$key = mysqli_real_escape_string($db, $$key); }
  // Leere numerische Variablen als NULL definieren
    if ($ICQ<1) $ICQ = NULL;
  // Define a prepared statement
  if ($stmt = mysqli_prepare($db, "UPDATE ".$prefix."guestbook SET
            Name = '".$Name."',
            Email = '".$Email."',
            URL = '".$URL."',
            ICQ = ?,
            Nachricht = '".$Nachricht."',
            Kommentar = '".$Kommentar."',
            Ort = '".$Ort."'
            WHERE GuestbookID = '".$ID."'
            LIMIT 1")) {
    mysqli_stmt_bind_param($stmt, "i", $ICQ);
    $result = mysqli_stmt_execute($stmt); }
  return $result; }

function addGuestbookEntry($Name, $Email, $URL, $ICQ, $Nachricht, $IP, $Ort):BOOL {
  $arg_list = get_defined_vars();
  global $prefix;
  global $db;
  $Datum = date("U");
  // Zufällige Zahl erzeugen
    mt_srand((double)microtime() * 1000000);
    $Code = mt_rand();
  // Optimize function arguments
    foreach($arg_list as $key => $value) {
      $$key = html_entity_decode($$key);
      $$key = mysqli_real_escape_string($db, $$key); }
  // Leere numerische Variablen als NULL definieren
    if (empty($Datum)) $Datum = "NULL";
    if (empty($ICQ)) $ICQ = "NULL";
    if (empty($Code)) $Code = "NULL";
  $sql = "INSERT INTO ".$prefix."guestbook (Datum,Name,Email,URL,ICQ,Nachricht,IP,Code,Ort)
    VALUES ($Datum, '$Name', '$Email', '$URL', $ICQ, '$Nachricht', '$IP', $Code, '$Ort')";
  $result = mysqli_query($db, $sql);
  // send email to administrator
    sendMail($Datum, $Name, $Ort, $Email, $URL, $ICQ, $Nachricht, $IP, $Code);
  return $result; }

function messageIsSpam($message, $ip, $url, $hiddenURL):String {
  // test for hidden URL
  if (!empty($hiddenURL))
    return 'hidden-url';
  // test for blocked IP
  $BlockedIPs = explode(", ", getSetup('SetupGuestbookSpamIPs'));
  $count = count($BlockedIPs);
  for( $i=0; $i<$count; $i++ )
    if ($ip == trim ($BlockedIPs[$i]))
      return 'blocked-ip';
  // test for blocked words
  $message = str_replace("\r\n", " ", $message);
  $message = str_replace(".", " ", $message);
  $message = str_replace(",", " ", $message);
  $message = str_replace(":", " ", $message);
  $message = str_replace(";", " ", $message);
  $BlockedWords = explode(", ", getSetup('SetupGuestbookSpamWords'));
  $count = count($BlockedWords);
  for( $i=0; $i<$count; $i++ ) {
    $word = trim ($BlockedWords[$i]);
    if (stristr(' '.$message.' ', ' '.$word.' ')) // v1.2.78_019
      return 'blocked-word: '.$word; }
  // test for blocked domains
  $BlockedDomains = explode(", ", getSetup('SetupGuestbookSpamDomains'));
  $count = count($BlockedDomains);
  for( $i=0; $i<$count; $i++ )
    if (stristr($url, trim ($BlockedDomains[$i])))
      return 'blocked-domain';
  // test for invalid characters
  $re = '[#]';
  if (preg_match( $re, $message, $matches, PREG_UNMATCHED_AS_NULL, 0))
    return 'blocked-character: '.implode(", ", $matches);
  return 'noSpam'; }

function isFormReload($gb_name, $gb_text, $gb_ip):BOOL {
  global $db;
  global $prefix;
  // escaping special characters for use in an SQL statement, e.g. 'O\'Connel'
    $gb_name = mysqli_real_escape_string($db, $gb_name);
    $gb_text = mysqli_real_escape_string($db, $gb_text);
  $sql = "SELECT count(*) as zahl  FROM ".$prefix."guestbook WHERE Name='".$gb_name."' AND Nachricht='".$gb_text."' AND IP='".$gb_ip."'";
  $result = mysqli_query($db, $sql);
  $row = mysqli_fetch_array($result);
  if ($row['zahl'])
    return true;
  else
    return false; }

function sendMail($Datum, $Name, $Ort, $Email, $URL, $ICQ, $Nachricht, $IP, $Code) {
  global $L_114;
  global $L_115;
  global $L_116;
  global $L_118;
  global $L_134;
  global $L_119;
  global $L_135;
  global $L_136;
  global $L_137;
  global $L_GuestbookLocation;
  global $L_ERROR_Email_could_not_be_sent;
  global $GigKalenderPath;
  // Define email message
  $MailMessage = "Datum: ".DatumUndUhrzeitAusTimestamp ($Datum);
  $MailMessage = $MailMessage."\n".$L_114.": ".$Name;
  $MailMessage = $MailMessage."\n".$L_GuestbookLocation.": ".$Ort;
  $MailMessage = $MailMessage."\n".$L_115.": ".$Email;
  $MailMessage = $MailMessage."\n".$L_116.": ".$URL;
  $MailMessage = $MailMessage."\n".$L_118.": ".$ICQ;
  $MailMessage = $MailMessage."\n".$L_134.": ".$IP;
  $MailMessage = $MailMessage."\n---";
  $MailMessage = $MailMessage."\n\n".$L_119.": ".$Nachricht;
  $MailMessage = $MailMessage."\n\n---";
  $MailMessage = $MailMessage."\n".$L_136.":\n".$GigKalenderPath."guestbook/guestbook_edit.php?code=".$Code;
  $MailMessage = $MailMessage."\n\n".$L_137.":\n".$GigKalenderPath."guestbook/guestbook_delete.php?code=".$Code;
  // Define email header
    $optheader[] = "From: ".$Name."< ".$Email." >";
    $optheader[] = "Content-Type: text/plain; Charset=utf-8";
    $Header = implode("\n", $optheader);
  // Send email
    if ( !@mail(getSetup('SetupGuestbookMail'), $L_135, $MailMessage, $Header) )
      echo '<span class="ErrorMessage">'.$L_ERROR_Email_could_not_be_sent.'</span><br /><br />'; }

function getGuestbookFrontendNavigation ($Locator):String {
  global $AnzahlSeiten;
  global $L_112;
  $URLform = getFrontendURL('SetupGuestbookFormURL');
  // Eintragen-Link
  $output = '<div class="GuestbookNavigation">
          <div class="GuestbookLinkForAddingEntries">[
            <form style="display:inline" id="form'.$Locator.'" method="post" action="'.$URLform.'" accept-charset="UTF-8">
              <p style="display:inline">
                <input type="hidden" name="page" value="form" />
                  <a href="'.$URLform.'" onclick="javascript:document.forms[\'form'.$Locator.'\'].submit()">
                    <img src="'.PATH.'frontend/images/guestbook_form.png" alt="" />'.$L_112.'</a>
              </p>
            </form> ]
          </div>';
  // Pagination
  if ($AnzahlSeiten>1) {
    global $aktuelleSeite;
    global $L_111;
    $output .= $L_111.': ';
    $URLgb = getFrontendURL('SetupGuestbookURL');
    $output .= getPagination( $URLgb, $AnzahlSeiten, $aktuelleSeite, "DESC", "gb_page"); }
  return $output .= '</div>'; }

  function isGuestbookEntryPresent ( $Code )
  {
    global $db;
    global $prefix;

    $result = @mysqli_query($db, "SELECT CODE FROM ".$prefix."guestbook WHERE CODE = ".$Code);
    $result = mysqli_num_rows($result);
    if ($result == true) return true;
    else return false;
  }

  function writeSpamLog ( $Name, $Ort, $Email, $EchteURL, $URL, $ICQ, $Nachricht, $IP, $Identifier, $Form )
  {
    global $SetupWriteGuestbookSpamLog;
    if ( $SetupWriteGuestbookSpamLog )
    {
      global $GigKalenderPath;
      global $GigKalenderVersion;
      $path = str_replace("\\","/",dirname(__FILE__));
      $datei = $path."/spam.log";
      $fp=fopen($datei,"a");
$String = '### '.convertTimestampToISO8601(date('U')).' ###
[ GigKalender-Version ]
'.$GigKalenderVersion.'
[ Form ]
'.$Form.'
[ Reason ]
'.$Identifier.'
[ Name ]
'.$Name.'
[ Location ]
'.$Ort.'
[ eMail ]
'.$Email.'
[ URL ]
'.$EchteURL.'
[ HiddenURL ]
'.$URL.'
[ ICQ ]
'.$ICQ.'
[ Message ]
'.$Nachricht.'
[ IP ]
'.$IP.'


';
      fwrite($fp,$String);
    }
  }
  
  function DatumUndUhrzeitAusTimestamp ($Timestamp)
  { 
    $Tag = date('d', $Timestamp);
    $Monat = date('m', $Timestamp);
    $Jahr = date('Y', $Timestamp);
    $Stunde = date('H', $Timestamp);
    $Minute = date('i', $Timestamp);
    return $Tag.".".$Monat.".".$Jahr." - ".$Stunde.":".$Minute." Uhr";
  }

  function testDoppelte ($Timestamp)
  {
    global $db;
    global $prefix;    
    
    $sql = 'SELECT * FROM ' .$prefix. "guestbook";
    $result = mysqli_query($db, $sql);
    $doppelteVorhanden = false;
    while($row = mysqli_fetch_row($result))
    {
      if (strtolower($row[1]) == $Timestamp) { $doppelteVorhanden = true; }
    }
    if ($doppelteVorhanden) return true;
    else return false;
}

  function AltenEintragHinzufuegen ($Tag, $Monat, $Jahr, $Stunde, $Minute, $Sekunde, $Name, $Email, $URL, $ICQ, $Nachricht, $Kommentar, $IP, $Code, $Ort)
  {
    global $prefix;
    global $db;

    $Datum = mktime($Stunde, $Minute, $Sekunde, $Monat, $Tag , $Jahr);
    if ( $URL=='http://' ) { $URL=''; }
    // HTML & PHP-Tags entfernen
      $Name = strip_tags($Name);
      $Email = strip_tags($Email);
      $ICQ = strip_tags($ICQ);
      $Nachricht = strip_tags($Nachricht);
      $Kommentar = strip_tags($Kommentar);
    // Maskieren spezieller Zeichen für die Verwendung in einer SQL-Anweisung
      $Name = mysqli_real_escape_string($db, $Name);
      $Email = mysqli_real_escape_string($db, $Email);
      $URL = mysqli_real_escape_string($db, $URL);
      $ICQ = mysqli_real_escape_string($db, $ICQ);
      $Nachricht = mysqli_real_escape_string($db, $Nachricht);
      $Kommentar = mysqli_real_escape_string($db, $Kommentar);
      $Ort = mysqli_real_escape_string($db, $Ort);
    // Leere numerische Variablen als NULL definieren
      if ( $Datum=='' ) $Datum="NULL";
      if ( $ICQ=='' ) $ICQ="NULL";
      if ( $Code=='' ) $Code="NULL";

    if (!testDoppelte($Datum))
    {   
      $SQL_Befehl = "INSERT INTO ".$prefix."guestbook (Datum,Name,Email,URL,ICQ,Nachricht,Kommentar,IP,Code,Ort)
      VALUES ($Datum, '$Name', '$Email', '$URL', $ICQ, '$Nachricht', '$Kommentar', '$IP', $Code, '$Ort')";
      $resultat = mysqli_query($db, $SQL_Befehl);
      if ($resultat) { return true; }
      else {return false;}
    }
    else { echo 'Error: Eintrag schon vorhanden.<br />';}
  }

  function AnzahlEintraege ()
  {
    global $prefix;
    global $db;

    $sql = "SELECT count(*) as zahl  FROM ".$prefix."guestbook";
    $result = mysqli_query($db, $sql);
    $row = mysqli_fetch_array($result);
    return $row['zahl'];
  }
?>