<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/
  $Path = str_replace('\\','/', __FILE__);
  $Path = str_replace('calendar/month.php', '', $Path);

  include_once($Path."gigkalender.ini.php");
  include_once($Path."functions/standard.php");
  include_once($Path."includes/frontend_language_selector.php");
  
  if (isset($_REQUEST['month'])) { $monat=$_REQUEST['month']; }
    else { $monat = date("n"); }
  if (isset($_REQUEST['year'])) { $Jahr=$_REQUEST['year']; }
    else { $Jahr = date("Y"); }
  if (isset($_REQUEST['GigID']))
  {
    $timestamp = getGigVarFromGigID ($_REQUEST['GigID'], 'GigDate');
    $monat=date("n", $timestamp);
    $Jahr=date("Y", $timestamp);
  }

  $ErsterWochentag = WochentagVonDatum (1, $monat, $Jahr);
  $TimestampVonHeute = TimestampAusDatum(date("d"), date("m"), date("y"));
  $Tag = 1;
  $Zelle = 1;
  $AnzahlTagedesMonats = AnzahlTagedesMonats ($monat, $Jahr);
  
  $MonthBackwards = $monat-1;
  $YearBackwards = $Jahr;
  if ( $MonthBackwards == '0') 
  {
    $MonthBackwards = '12';
    $YearBackwards  = $Jahr-1;
  }
  $MonthForwards = $monat+1;
  $YearForwards = $Jahr;
  if ( $MonthForwards == '13') 
  {
    $MonthForwards = '1';
    $YearForwards  = $Jahr+1;
  }
  // Kalender-Grenzen bestimmen
    $TimestampOfFirstDayOfShownMonth = TimestampAusDatum( 1, $monat, $Jahr);
    // Limit der Vergangenheit bestimmen
      $LimitPastMonth = date("m")-$SetupFrontendCalendarCurrentMonthLimitPast;
      $LimitPastYear = date("y");
      if ($LimitPastMonth<1)
      {
        $LimitPastMonth = $LimitPastMonth+12;
        $LimitPastYear--;
      }
    // Limit der Zukunft bestimmen
      $LimitPast = TimestampAusDatum( 1, $LimitPastMonth, $LimitPastYear);
      $LimitFutureMonth = date("m")+$SetupFrontendCalendarCurrentMonthLimitFuture;
      $LimitFutureYear = date("y");
      if ($LimitFutureMonth>12)
      {
        $LimitFutureMonth = $LimitFutureMonth-12;
        $LimitFutureYear++;
      }
      $LimitFuture = TimestampAusDatum( 1, $LimitFutureMonth, $LimitFutureYear);
  echo '<div id="CalendarCurrentMonth">
        <table summary="CalendarCurrentMonth">
          <tr>';
  // URL bestimmen
    $URL = getFrontendURL ( 'SetupFrontendCalendarCurrentMonthURL' );
  echo '<td class="NavigationBackwards"><a href="'.$URL.'year='.$YearBackwards.'&amp;month='.$MonthBackwards.'">';
  if ( $TimestampOfFirstDayOfShownMonth>$LimitPast ) echo '&laquo;';
    else echo ' ';
  echo '</a></td>
            <td colspan="5"><span class="Month">'.getNameOfMonthFromNumberOfMonth ($monat).' '.$Jahr.'</span></td>
            <td class="NavigationForwards"><a href="'.$URL.'year='.$YearForwards.'&amp;month='.$MonthForwards.'">';
  if ( $LimitFuture>$TimestampOfFirstDayOfShownMonth ) echo '&raquo;';
    else echo ' ';
  echo '</a></td>
          </tr>
          <tr id="Weekdays">
            <td>'.$L_Mo.'</td>
            <td>'.$L_Tu.'</td>
            <td>'.$L_We.'</td>
            <td>'.$L_Th.'</td>
            <td>'.$L_Fr.'</td>
            <td>'.$L_Sa.'</td>
            <td>'.$L_Su.'</td>
          </tr>
          <tr>';
          
  for ($z=1; $z<=6 AND $Tag <= $AnzahlTagedesMonats; $z++) {
    for ($s=1; $s<=7; $s++) {
      if (($Zelle < $ErsterWochentag) OR ($Tag > $AnzahlTagedesMonats)) {echo "<td></td>";}
      else {
        $timestamp = TimestampAusDatum($Tag, $monat, $Jahr);
        if ( !DatumInZukunft($timestamp) AND !$SetupFrontendCalendarCurrentMonthShowPastGigs )
          $PublishedGigPresent = false;
        else
          $PublishedGigPresent = publishedGigOnTimestamp($timestamp);
        echo '<td>';
        echo '<div class="'.WochentagsNameVonDatum ($Tag, $monat, $Jahr).'">';
        if ($timestamp == $TimestampVonHeute) { echo '<span class="Today">'; }

        // Wochentags-Zahl mit Link
        if ( !$PublishedGigPresent )
          echo $Tag;
        else {
          echo '<div class="Gig">';
          $ToolTip = GetTooltip($timestamp);
          $URL = getFrontendURL ( 'SetupFrontendCalendarGigDetailsURL' );
          $URL = $URL.'&amp;year='.$Jahr.'&amp;month='.$monat;
          echo '<form style="margin: 0; padding: 0; display: inline;" id="form'.$timestamp.'" method="post" action="'.$URL.'" accept-charset="UTF-8">
                  <p style="margin: 0; padding: 0; display: inline;" title="'.$ToolTip.'">
                    <input type="hidden" name="timestamp" value="'.$timestamp.'" />
                    <a href="'.$URL.'" onclick="javascript:document.forms[\'form'.$timestamp.'\'].submit()">'.$Tag.'</a>
                  </p>
                </form>';
          echo '</div>';
        }
        if ($timestamp == $TimestampVonHeute) echo "</span>";
        echo "</div>";
        echo "</td>\n";
        $Tag++;
      }
      if ($s == "7") {
        if ($z < "6" AND $Tag <= $AnzahlTagedesMonats)
          echo "</tr><tr>";
        else
          echo "</tr>";
      }
      $Zelle++;
    }
  }
  echo '</table></div>';
?>