<?php
// ############         Edit below         ########################################
$topic_length = '50';   // length of topic title
$topic_limit = '25';   // limit of displayed topics
$special_forums = '0';   // specify forums ('0' = no; '1' = yes)
$forum_ids = '3,5,6,7';      // IDs of forums; separate them with a comma

$config_path = '/';   // path to config.php
$root_path = 'https://www.paderdesign.de/forum/';      // link path
// ############         Edit above         #######################################

$path = dirname(__FILE__);
include_once($path.$config_path .'config.php');
$db = mysqli_connect ($dbhost, $dbuser, $dbpasswd) OR die('Unable to select server.');
mysqli_select_db($db, $dbname) OR die('Unable to select database.');
mysqli_query($db, 'SET NAMES utf8'); // latin1
mysqli_query($db, 'SET CHARACTER SET utf8');


// ############## output ##############
  echo '<!DOCTYPE html>
          <html lang="en">
            <head>
              <meta http-equiv="content-type" content="text/html; charset=utf-8" />
              <meta name="robots" content="NOINDEX,NOFOLLOW" />
              <link rel="stylesheet" type="text/css" media="screen, print" href="https://www.paderdesign.de/gigkalender/demo/styles/gigkalender.css" />
              <link rel="stylesheet" type="text/css" media="print" href="https://www.paderdesign.de/gigkalender/demo/styles/gigkalender_print.css" />
              <link rel="shortcut icon" href="https://www.paderdesign.de/gigkalender/demo/images/favicon.ico" />
              <title>GigKalender-Forum</title>
            </head>
            <body style="margin:0">
            <table id="Table_DSF-Top5" style="width: 100%">
              <!--<tr>
                 <td colspan="4">Die '. $topic_limit .' letzten Themen im Forum</td>
              </tr>-->
              <tr>
                <th>Forums</th>
                <th>Topics</th>
                <th>Authors</th>
                <th>Last Post</th>
              </tr>';
// ############## output ##############

$where_forums = ( $special_forums == '0' ) ? '' : 't.forum_id NOT IN ('. $forum_ids .') AND ';
$SQLQuery = "SELECT t.*, f.forum_id, f.forum_name, u.username AS first_poster, u.user_id AS first_poster_id, u2.username AS last_poster, u2.user_id AS last_poster_id, p.post_username AS first_poster_name, p2.post_username AS last_poster_name, p2.post_time
   FROM ". $table_prefix ."topics t, ". $table_prefix ."forums f, ". $table_prefix ."users u, ". $table_prefix ."posts p, ". $table_prefix ."posts p2, ". $table_prefix ."users u2
   WHERE $where_forums t.topic_poster = u.user_id AND f.forum_id = t.forum_id AND p.post_id = t.topic_first_post_id AND p2.post_id = t.topic_last_post_id AND u2.user_id = p2.poster_id
   ORDER BY t.topic_last_post_id DESC LIMIT $topic_limit";
$Result = mysqli_query($db, $SQLQuery);
if( !$Result )
{
   die('SQL Statement Error: '. mysqli_error($db));
   exit();
}

$line = array();
while( $row = mysqli_fetch_array($Result) )
{
   $line[] = $row;
}

for( $i = 0; $i < count($line); $i++ )
{
   $forum_id = $line[$i]['forum_id'];
   $forum_url = $root_path .'viewforum.php?f='. $forum_id;
   $topic_id = $line[$i]['topic_id'];
   $topic_url = $root_path .'viewtopic.php?t='. $topic_id;

   $topic_title = ( strlen($line[$i]['topic_title']) < $topic_length ) ? $line[$i]['topic_title'] : substr(stripslashes($line[$i]['topic_title']), 0, $topic_length) .'…';

   $topic_type =  ( $line[$i]['topic_type'] == '2' ) ? 'Announcement ': '';
   $topic_type .= ( $line[$i]['topic_type'] == '3' ) ? 'Global Announcement ': '';
   $topic_type .= ( $line[$i]['topic_type'] == '1' ) ? 'Sticky ': '';
   $topic_type .= ( $line[$i]['topic_vote'] ) ? 'Poll ': '';

   $views = $line[$i]['topic_views'];
   $replies = $line[$i]['topic_replies'];

   $first_time = date('Y-m-d - H:m', $line[$i]['topic_time']);
   $first_author = ( $line[$i]['first_poster_id'] != '-1' ) ? '<a href="'. $root_path .'memberlist.php?mode=viewprofile&amp;u='. $line[$i]['first_poster_id'] .'">'. $line[$i]['first_poster'] .'</a>' : ( ($line[$i]['first_poster_name'] != '' ) ? $line[$i]['first_poster_name'] : 'guest' );
   $last_time = date('Y-m-d - H:m', $line[$i]['post_time']);
   $last_author = ( $line[$i]['last_poster_id'] != '-1' ) ? $line[$i]['last_poster'] : ( ($line[$i]['last_poster_name'] != '' ) ? $line[$i]['last_poster_name'] : 'guest' );
   $last_url = '<a href="'. $root_path .'viewtopic.php?p='. $line[$i]['topic_last_post_id'] .'#p'. $line[$i]['topic_last_post_id'] .'" style="text-decoration: none; margin:0; font-weight:bold;">→</a>';

   // ############## output ##############
   echo '<tr>
            <td><a href="'. $forum_url .'">
            '. $line[$i]['forum_name'] .'</a></td>
            <td><a href="'. $topic_url .'">
            '. $topic_title .'</a></td>
            <td>'.$first_author.'</td>
            <td>'. $last_time .' by '.$last_author .' '.$last_url.'</td>
        </tr>';
   // ############## output ##############
}
echo '</table></body></html>';
mysqli_close($db);
?>