<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/

function getArrayOfImagesInFolder ( $Folder ) {
  global $AlbumsPathLocal;
  $files = array();
  $files = glob( $AlbumsPathLocal.$Folder."/*.{[jJ][pP][gG],[jJ][pP][eE][gG],[gG][iI][fF],[pP][nN][gG]}", GLOB_BRACE);
  array_multisort($files);
  $count = count($files);
  for ($i=0; $i<$count; $i++)
    $files[$i] = basename($files[$i]); // remove paths
  return $files; }

  function scaleImage  ( $Album, $subfolder, $ImageFileName )
  {
    global $AlbumsPathLocal;
    global $CachePathLocal;
    global $CachePath;
    global $GigKalenderPath;
    global $Path;
    global $SetupFrontendGalleryImagesWidth;
    global $SetupFrontendGalleryJpegQuality;
    global $SetupFrontendGalleryPNGQuality;
    global $SetupFrontendGalleryThumbnailsWidth;
    global $SetupFrontendGalleryImageFormat;
    global $SetupFrontendGalleryImagesInterlacing;

    $SourcePath = $AlbumsPathLocal.$Album.'/original/'.$ImageFileName;
    $OutputPath = $Path.'cache/gallery/albums/'.$Album.'/'.$subfolder.'/';
    $OutputPathLocal = $CachePath.$Album.'/'.$subfolder.'/';
    
    // Neue Größe berechnen
    list($width, $height, $type) = getimagesize($SourcePath);
    $ratio = $width/$height;
    if ($subfolder=='thumbnails') $newwidth = $SetupFrontendGalleryThumbnailsWidth;
    elseif ($subfolder=='images') $newwidth = $SetupFrontendGalleryImagesWidth;
    $newheight = $newwidth/$ratio;

    // Bild laden
    $output = imagecreatetruecolor($newwidth, $newheight);
    switch ($type) {
        case 1 : $source = imageCreateFromGif($SourcePath); break;
        case 2 : $source = imageCreateFromJpeg($SourcePath); break;
        case 3 : $source = imageCreateFromPng($SourcePath); break;
        default: echo "ERROR: Unknown inmage format.";
    }
    //$source = imagecreatefromjpeg($SourcePath);

    // Skalieren
    imagecopyresampled($output, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

    // Enable interlancing
    if ($subfolder=='images') imageinterlace($output, $SetupFrontendGalleryImagesInterlacing);

    // Ausgabe
    if (!file_exists($OutputPath))
    {
      if (!mkdir($OutputPath, 0777, true))
        die('Failed to create folders…(gallery/functions.php:46: '.$Album.')');
    }
    switch ($type) {
        case 1 :
          if (!imagegif($output, $OutputPath.$ImageFileName))
          {
            die('Failed to save image… (gallery/functions.php:53: '.$Album.')');
          }
          break;
        case 2 : 
          if (!imagejpeg($output, $OutputPath.$ImageFileName, $SetupFrontendGalleryJpegQuality))
          {
            die('Failed to save image… (gallery/functions.php:53: '.$Album.')');
          }
          break;
        case 3 :
          if (!imagepng($output, $OutputPath.$ImageFileName, $SetupFrontendGalleryPNGQuality))
          {
            die('Failed to save image… (gallery/functions.php:53: '.$Album.')');
          }
          break;
    }
    // Den Speicher freigeben
    imagedestroy($output);
  }

  function checkIfOriginalIsPresent ( $Album, $ImageFileName )
  {
    global $AlbumsPathLocal;
    global $PossibleImageExtensions;
    $Array = explode ( '.', $ImageFileName );
    $ImageFileName = $Array[0];
    $PathOfOriginal = $AlbumsPathLocal.$Album.'/original/'.$ImageFileName;
    for ($i=0; $i<count($PossibleImageExtensions); $i++)
    {
      if (is_file($PathOfOriginal.'.'.$PossibleImageExtensions[$i])) return $ImageFileName.'.'.$PossibleImageExtensions[$i];
    }
    return false;
  }
  function getArrayOfAllAlbums ( $Directory )
  {
    $handle=opendir($Directory);
    $files = array();
    while ($file = readdir ($handle))
    if ($file != "." && $file != "..") { $files[] = $file; }
    array_multisort($files);
    return $files;
  }

  function getTextFile ( $Album, $TextFile, $ImageFileName )
  {
    global $AlbumsPathLocal;
    global $PossibleTextExtensions;
    $Array = explode ( '.', $ImageFileName );
    $ImageFileName = $Array[0];


    if ($TextFile=='image') $TextPath = $AlbumsPathLocal.$Album.'/text/'.$ImageFileName;
    if ($TextFile=='title') $TextPath = $AlbumsPathLocal.$Album.'/title';
    if ($TextFile=='description') $TextPath = $AlbumsPathLocal.$Album.'/description';

    for ($i=0; $i<count($PossibleTextExtensions); $i++)
    {
      $TextFilePath = $TextPath.'.'.$PossibleTextExtensions[$i];
      if (is_file($TextFilePath))
      {
        if ( filesize($TextFilePath)>0 )
        {
          $fp = fopen ( $TextFilePath, 'r' );
          $Text = fread ( $fp, filesize ( $TextFilePath ) );
          fclose ( $fp );
          return $Text;
        }
        else return false;
      }
    }
  }

?>