<?php
  echo '<h1 class="Headline">Updating GigKalender to '.$GigKalenderVersion.'</h1>';
  // Define database updates
  $Updates = array(
    // v1.2.63_043
    //"ALTER TABLE `".$prefix."gigs` CHANGE `GigPostalCode` `GigPostalCode` CHAR( 10 ) NULL",
    // v1.2.63_044
    //"ALTER TABLE `".$prefix."user` CHANGE `UserName` `UserName` CHAR( 20 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL",
    // v1.2.63_071
    //"UPDATE ".$prefix."gigs SET GigPostalCode='' WHERE GigPostalCode='0'"
    // v1.2.72_001
    //"ALTER TABLE `".$prefix."news` CHANGE `AddedFrom` `AddedFrom` CHAR(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL"
    // v1.2.72_002
    //"ALTER TABLE `".$prefix."news` CHANGE `LastEditor` `LastEditor` CHAR(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL",
    // v1.2.77_014
    //"ALTER TABLE `".$prefix."user` CHANGE `UserCurrentPassword` `UserCurrentPassword` CHAR(24) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL",
    // v1.2.80_002
    //"ALTER TABLE `".$prefix."setup` CHANGE `SetupUserMaximumInactivityTime` `SetupUserMaximumInactivityTime` SMALLINT(3) NOT NULL"
    );

  // Update database
    $AmountErrors = 0;
    $AmountUpdates = count($Updates);
    if ($AmountUpdates>0)
    {
      echo '<h2>Updating database</h2>';
      for ($i=0; $i<$AmountUpdates; $i++)
      {
        $sql = $Updates[$i];
        $result = mysqli_query($db, $sql);
        if (!$result)
        {
          echo '<span style="font-size:0.8em" class="ErrorMessage">- ERROR: Database update ['.$i.'] failed: '.$sql.'</span><br/>';
          $AmountErrors++;
        }
        else
          echo '<span style="font-size:0.8em">- '.$sql.'</span><br />';
      }
      if ($AmountErrors==0)
      {
          echo '<span style="font-size:0.8em">Database sucessfully updated! </span><br />';
      }
    }

  // Deleting files and folders
    $FilesForDeletion = array(
      // v1.2.61_044
        //"styles/gigkalender.css11",
      // v1.2.63_006:
        //"readme.txt",
      // v1.2.63_022
        //"history.txt",
      // v1.2.63_024
        //"images/gigs.gif",
      // v1.2.63_025
        //"images/kalender_vergangenheit.gif",
      // v1.2.63_026
        //"images/kalender_zukunft.gif",
      // v1.2.63_027
        //"images/login.gif",
      // v1.2.63_028
        //"images/logout.gif",
      // v1.2.63_029:
        //"images/rss.svg",
      // v1.2.63_030
        //"images/update.gif",
      // v1.2.63_031
        //"includes/fuzzing.user.js",
      // v1.2.63_032:
        //"includes/reloadblocker.php",
      // v1.2.65_008
        //"phpinfo.php",
      // v1.2.75
        //"editor",
      // v1.2.75_015
        //"includes/donate.php",
      
        //"install/index4.php", // v1.2.76_017
        //"frontend/example_calendar-future-and-past.php", // v1.2.76_021
        //"calendar/includes/addGig/autocomplete", // v1.2.77_022
        //"images/valid-rss.png", // v1.2.77_030
        //"guestbook/guestbook_add.php", // v1.2.78_037
        //"frontend/images/guestbook_add.png", // v1.2.78_039
      
        //"images/bgindex.jpg", // v1.2.80_047
        //"frontend/example_guestbook_add.php", // v1.2.80_104
        //"calendar/includes/showAllGigs/subString.php", // v1.2.80_119
        //"calendar\includes\showAllGigs\GigDate.php", // v1.2.80_120
        //"includes/editor", // v1.2.80_123
        //"contact-form/gigKalender_kontaktForm_v06.php", // v1.2.80_139
        //"contact-form/gigKalender_kontaktForm_v07.php", // v1.2.80_140
        //"contact-form/gigKalender_kontaktForm_v08.php", // v1.2.80_141
      // Current Development

      // Common
        "update.sql.php.old"
      );
    //$AmountErrors = 0;
    $AmountDeletions = count($FilesForDeletion);
    if ($AmountDeletions>0) {
      echo '<h2>Deleting old files and folders</h2>';
      for ($i=0; $i<$AmountDeletions; $i++) {
        if (is_file($FilesForDeletion[$i])) {
          $result = @unlink($FilesForDeletion[$i]);
          if ($result) {
            echo '<span style="font-size:0.8em">- File ['.$i.'] deleted: '.$FilesForDeletion[$i].'</span><br />';
            }
          else {
            echo '<span style="font-size:0.8em" class="ErrorMessage">- ERROR: Deleting a file failed: '.$FilesForDeletion[$i].'</span><br />';
            $AmountErrors++;
          }}
        elseif (is_dir($FilesForDeletion[$i])) {
          emptyDirectory ($FilesForDeletion[$i]);
          $result = @rmdir ($FilesForDeletion[$i]);
          if ($result)
            echo '<span style="font-size:0.8em">- Folder ['.$i.'] deleted: '.$FilesForDeletion[$i].'</span><br />';
          else {
            echo '<span style="font-size:0.8em" class="ErrorMessage">- ERROR: Deleting a folder failed:  '.$FilesForDeletion[$i].'</span><br />';
            $AmountErrors++;
          }
        }
        //else
          //echo '<span style="font-size:0.8em">- File or Folder ['.$i.']  does not exist: '.$FilesForDeletion[$i].'</span><br />';
      }
      if ($AmountErrors==0) {
          echo '<span style="font-size:0.8em">Old files sucessfully deleted!</span>'; }
    }
    //if (is_file("update.sql.php.old")) unlink("update.sql.php.old");

  // Renaming files and folders
    $Rename = array(
      // v1.2.80_009
      //"filesharing/notes"  => "filesharing/sheetmusic",
      // v1.2.80_010
      //"filesharing/downloadNotes.php"  => "filesharing/downloadSheetMusic.php"
      // v1.2.80_173
      "admin/includes/setup/SetupRefreshtime.php"  => "admin/includes/setup/SetupRefreshTime.php"
    );
    $countRename = count($Rename);
    if ($countRename>0) {
      echo '<h2>Renaming of files and folders</h2>';
      foreach ($Rename as $key => $value) {
        if (is_file($key)) {
          $result = rename ( $key, $value);
          if ($result==TRUE)
            echo '<span style="font-size:0.8em">- File '.$key.' renamed into '.$value.'.</span><br />';
          else {
            echo '<span style="font-size:0.8em" class="ErrorMessage">- ERROR: Renaming the file '.$key.' into '.$value.' failed!</span><br />';
            $AmountErrors++; }}
        elseif (is_dir($key)) {
          $result = rename ( $key, $value);
          if ($result==1) // Folder has been deleted
            echo '<span style="font-size:0.8em">- Folder '.$key.' renamed into '.$value.'.</span><br />';
          else { // Deleting folder failed
            echo '<span style="font-size:0.8em" class="ErrorMessage">- ERROR: Renaming the folder '.$key.' into '.$value.' failed!</span><br />';
            $AmountErrors++; }}
        else { 
          if (is_file($value) OR is_dir($value)) // v1.2.80_174
            echo '<span style="font-size:0.8em; background-color: #696969">
              - Target file or folder already exists: '.$value.'</span><br />';
          else
            echo '<span style="font-size:0.8em" class="ErrorMessage">
              - ERROR: File or folder does not exist: '.$key.'</span><br />';
        }
      }
    }

  if (!isset($BackURL)) $BackURL = $_SERVER['HTTP_REFERER'];
  if ($AmountErrors==0) {
    echo '<h2>Finalise</h2>';
    // Maybe renaming installation folder here

    // Rewrite Feeds
      include_once ('news/functions.php');
      writeAllFeeds();
      echo '<span style="font-size:0.8em">The news feeds have been rewritten.</span><br />';
    // Clear Cache
      clearCache();
      echo '<span style="font-size:0.8em">The cache has been cleared.</span><br />';
    // Rename update script
      if (@rename("update.sql.php", "update.sql.php.old"))
        echo '<span style="font-size:0.8em">This script has been renamed to update.sql.php.old.</span><br />';
      else
        echo '<span style="font-size:0.8em" class="ErrorMessage">
                ERROR: Wrong permissions ('.substr(decoct(fileperms("update.sql.php")),3).'):
                Please rename update.sql.php into update.sql.php.old manually.</span><br />';
    $ButtonValue = "OK";
  }
  else
    $ButtonValue = "Retry";
  echo '<br><form>
        <input type="button" value="'.$ButtonValue.'" onclick="window.location.href=\''.$BackURL.'\'" class="button" />
      </form>';
  die();
?>