<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/
  echo '<p class="Headline">'.$L_Headline23.'</p>';
  $REQUEST_URI = str_replace( '&', '&amp;', $_SERVER['REQUEST_URI']);
    // Individuelle Headline ausgeben
    switch ( $Selector )
    {
      case "backend_addGig": echo $L_208; break;
      case "backend_showAllGigs": echo $L_207; break;
      case "frontend": echo $L_078; break;
      case "frontend_details": echo $L_209; break;
    }
    echo '<br /><br />';
    // Alle möglichen Attribute definieren
    switch ( $Selector )
    {
      case "backend_addGig": $AllPossibleAttributes = explode(', ', $allBackendCalenderFormAttributes); break;
      case "backend_showAllGigs": $AllPossibleAttributes = explode(', ', $allGigAttributes); break;
      case "frontend": $AllPossibleAttributes = explode(', ', $allFrontendAttributes); break;
      case "frontend_details": $AllPossibleAttributes = explode(', ', $allFrontendDetailAttributes); break;
    }
    // Aktive Attribute abfragen
    switch ( $Selector )
    {
      case "backend_addGig": $Attributes = array_filter(explode(", ", getSetup('SetupCalendarAttributeInAddGigForm'))); break;
      case "backend_showAllGigs": $Attributes = array_filter(explode(", ", getCurrentUserVar('UserBackendCalenderListCols'))); break;
      case "frontend": $Attributes = array_filter(explode(", ", getSetup('SetupFrontendAttributes'))); break;
      case "frontend_details": $Attributes = array_filter(explode(", ", getSetup('SetupFrontendDetailAttributes'))); break;
    }
    // Ein Attribut deaktivieren
    if ( isset($_POST['AttributeDeactivated_x']) )
    {
      unset($Attributes[$AttributeID]);
      $NewAttributes = $Attributes;
    }
    // Attribut höher setzen
    if ( isset($_POST['AttributeUp_x']) )
    {
      $temp = $Attributes[$AttributeID-1];
      $Attributes[$AttributeID-1] = $Attributes[$AttributeID];
      $Attributes[$AttributeID] = $temp;
      $NewAttributes = $Attributes;
    }
    // Attribute tiefer setzen
    if ( isset($_POST['AttributeDown_x']) )
    {
      $temp = $Attributes[$AttributeID+1];
      $Attributes[$AttributeID+1] = $Attributes[$AttributeID];
      $Attributes[$AttributeID] = $temp;
      $NewAttributes = $Attributes;
    }
    // Ein Attribut aktivieren
    if ( isset($_POST['AttributeActivated_x']) )
    {
      array_push ( $Attributes, $AttributeID );
      $NewAttributes = $Attributes;
    }
    // Unzulässige Attribute aus Datenbank löschen
      $UpdateAttributeInDatabase = false;
      if ( count($Attributes)!=0 )
        {
          for ($i=0; $i<count($Attributes); $i++)
          {
            $Attributes = array_values($Attributes);
            if( !in_array($Attributes[$i], $AllPossibleAttributes))
            {
              echo '<span class="ErrorMessage">'.$L_ERROR_Forbidden_attribute_was_deleted.' ('.$Attributes[$i].')</span><br />';
              unset($Attributes[$i]);
              $UpdateAttributeInDatabase = true;
            }
          }
        }
    // Standard-Attribute setzen
      if ( isset($_POST['Standard']) )
      {
        switch ( $Selector )
        {
          case "backend_addGig": $NewAttributes = explode (", ", $allBackendCalenderFormAttributes); break;
          case "backend_showAllGigs": $NewAttributes = explode (", ", $StandardUserBackendCalenderListCols); break;
          case "frontend": $NewAttributes = explode (", ", $StandardFrontendAttributes); break;
          case "frontend_details": $NewAttributes = explode (", ", $StandardFrontendDetailAttributes); break;
        }
      }
    // Alle Attribute setzen
      if ( isset($_POST['AllAttributes']) )
      {
        switch ( $Selector )
        {
          case "backend_addGig": $NewAttributes = explode (", ", $allBackendCalenderFormAttributes); break;
          case "backend_showAllGigs": $NewAttributes = explode (", ", $allGigAttributes); break;
          case "frontend": $NewAttributes = explode (", ", $allFrontendAttributes); break;
          case "frontend_details": $NewAttributes = explode (", ", $allFrontendDetailAttributes); break;
        }
      }
    // Änderungen in Datenbank speichern
      if ( isset($_POST['AttributeDeactivated_x'])
          OR isset($_POST['AttributeUp_x'])
          OR isset($_POST['AttributeDown_x'])
          OR isset($_POST['AttributeActivated_x'])
          OR isset($_POST['Standard'])
          OR isset($_POST['AllAttributes'])
          OR $UpdateAttributeInDatabase )
        {
          // Doppelte Einträge löschen
            $NewAttributes = array_unique($NewAttributes);
          // Array komprimieren
            $NewAttributes = array_values($NewAttributes);
          $Value = implode (", ", $NewAttributes );
          switch ( $Selector )
          {
            case "backend_addGig": setSetupVar ( 'SetupCalendarAttributeInAddGigForm', $Value ); break;
            case "backend_showAllGigs": setUserVar ( 'UserBackendCalenderListCols', $Value ); break;
            case "frontend": setSetupVar ( 'SetupFrontendAttributes', $Value ); break;
            case "frontend_details": setSetupVar ( 'SetupFrontendDetailAttributes', $Value ); break;
          }
        }
    // Aktive Attribute abfragen
      switch ( $Selector )
      {
        case "backend_addGig": $Attributes = array_filter(explode(", ", getSetup('SetupCalendarAttributeInAddGigForm'))); break;
        case "backend_showAllGigs": $Attributes = array_filter(explode(", ", getCurrentUserVar('UserBackendCalenderListCols'))); break;
        case "frontend": $Attributes = array_filter(explode(", ", getSetup('SetupFrontendAttributes'))); break;
        case "frontend_details": $Attributes = array_filter(explode(", ", getSetup('SetupFrontendDetailAttributes'))); break;
      }
    // Ausgabe Tabelle
      echo '<table id="NarrowTable" summary="EditAttributes" style="float:left">';
      echo '<colgroup>
              <col />
              <col />
              <col class="SpalteIcon" />
              <col class="SpalteIcon" />
              <col class="SpalteIcon TabellenSpalte_Rechts" />
            </colgroup>';
      echo '<tr><th></th><th>'.$L_AttributeName.'</th><th>&nbsp;</th><th></th><th></th><th></th></tr>';
    // Aktive Attribute anzeigen
    $count = count($Attributes);
    if ($count>0)
    {
      for ($i=0; $i<$count; $i++)
      {
          // Attribut-Nummer
          $AttributeNumber = $i+1;
          echo '<tr>
                  <td style="text-align:right">'.$AttributeNumber.'</td>';
          // Attribut-Name
          echo '<td>'.${'L_'.$Attributes[$i]}.'</td>';
          // Icon zum Deaktivieren
            echo '<td>
                    <form method="post" action="'.$REQUEST_URI.'" accept-charset="UTF-8">
                      <fieldset>
                        <input type="hidden" name="Selector" value="'.$Selector.'" />
                        <input type="hidden" name="AttributeID" value="'.$i.'" />
                        <input title="'.$L_201.'" name="AttributeDeactivated" src="images/exist.gif" style="border:0; width:16px;" type="image" value="'.$i.'" />
                      </fieldset>
                    </form>
                  </td>
                  <td>';
          // Icon zum höher setzen
                    if ( $i!=0 )
                    {
                      echo '<form method="post" action="'.$REQUEST_URI.'" accept-charset="UTF-8">
                              <fieldset>
                                <input type="hidden" name="Selector" value="'.$Selector.'" />
                                <input type="hidden" name="AttributeID" value="'.$i.'" />
                                <input title="" name="AttributeUp" src="images/up.gif" style="border:0; width:16px;" type="image" value="'.$i.'" />
                              </fieldset>
                            </form>';
                    }
                    else '&nbsp;';
                    echo '
                  </td>
                  <td class="TabellenSpalte_Rechts">';
          // Icon zum tiefer setzen
                    if ( $i<$count-1 )
                    {
                      echo '<form method="post" action="'.$REQUEST_URI.'" accept-charset="UTF-8">
                              <fieldset>
                                <input type="hidden" name="Selector" value="'.$Selector.'" />
                                <input type="hidden" name="AttributeID" value="'.$i.'" />
                                <input title="" name="AttributeDown" src="images/down.gif" style="border:0; width:16px;" type="image" value="'.$i.'" />
                              </fieldset>
                            </form>';
                    }
                    else '&nbsp;';
                    echo '
                  </td>
                </tr>';
      }
    }
    // Deaktive Attribute anzeigen
    $DeactivatedAttributes = array_diff ( $AllPossibleAttributes, $Attributes );
    foreach ($DeactivatedAttributes as $key => $val)
    {
      // Icon zum Aktivieren
      echo '<tr>
              <td>&nbsp;</td>
              <td>'.${'L_'.$val}.'</td>
              <td>
                <form method="post" action="'.$REQUEST_URI.'" accept-charset="UTF-8">
                  <fieldset>
                    <input type="hidden" name="Selector" value="'.$Selector.'" />
                    <input type="hidden" name="AttributeID" value="'.$val.'" />
                    <input title="" name="AttributeActivated" src="images/dontexist.gif" style="border:0; width:16px;" type="image" value="'.$val.'" />
                  </fieldset>
                </form>
              </td>
              <td>&nbsp;</td>
              <td class="TabellenSpalte_Rechts">&nbsp;</td>
            </tr>';
    }
    echo '</table>';
    // Zurück-Button
    echo '<div style="float:left;margin:1em">';
    echo '<form method="post" action="index.php?submenue='.$submenue.'&amp;content='.$referer.'&amp;job='.$job.'&amp;id='.$id.'" accept-charset="UTF-8">
            <fieldset>
              <input type="submit" value="'.$L_Button04.'" class="SmallButton" />
              <input type="hidden" name="referer" value="'.$referer.'" />
              <input type="hidden" name="timestamp" value="'.$timestamp.'" />
            </fieldset>
          </form>';
    // Standart-Button
    echo '<form method="post" action="'.$REQUEST_URI.'" accept-charset="UTF-8">
            <fieldset>
              <input name="Standard" type="submit" value="'.$L_Button39.'" class="SmallButton" />
              <input type="hidden" name="Selector" value="'.$Selector.'" />
              <input type="hidden" name="timestamp" value="'.$timestamp.'" />
            </fieldset>
          </form>';
    // Alle-Attribute-Button
    echo '<form method="post" action="'.$REQUEST_URI.'" accept-charset="UTF-8">
            <fieldset>
              <input name="AllAttributes" type="submit" value="'.$L_Button40.'" class="SmallButton" />
              <input type="hidden" name="Selector" value="'.$Selector.'" />
              <input type="hidden" name="timestamp" value="'.$timestamp.'" />
            </fieldset>
          </form>';
  echo '</div>';
?>