<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/
  session_name('GigKalender');
  session_start();
  $session_id = session_id();

  include("includes/error_reporting.php");
  header("content-type: text/html; charset=utf-8");
  include("gigkalender.ini.php");
  include("functions/standard.php");

  // define vars
    foreach ($_REQUEST as $key => $value) {
      if (!is_array($value))
        $$key = stripslashes($value);
      else
        $$key = $value; }
    foreach ($_POST as $key => $value) {
      if (!is_array($value))
        $$key = stripslashes($value);
      else
        $$key = $value; }
  // Login
    if (isset($_POST['login']))
    {
      $userid=getUID($_POST['username'], $_POST['userpass']);
      if ($userid==true) { login($userid); }
    }
    else
    {
      logoutInactiveUser();
    }

  include('includes/backend_language_selector.php');

  // Fehlermeldung ausgeben
    $Message = '';
    if (isset($_POST['login']))
    {
      $userid=getUID($_POST['username'], $_POST['userpass']);
      if (!$userid) { $Message = '<div class="ErrorMessage">'.$L_071.'</div>'; }
    }

  // Logout
    if (isset($_POST['logout']))
    {
      logout();
      $Message = '<div class="ErrorMessage">'.$L_004.'</div>';
    }

  $timer = startTime();

  if (isset($_REQUEST['submenue'])) { $Submenue = $_REQUEST['submenue']; }
  else { $Submenue = "calendar"; }

  if (isset($_REQUEST['content'])) { $Content = $_REQUEST['content']; }
  else {
    switch ( $Submenue ) {
      case "calendar": $Content ="backend_showAllGigs"; break;
      case "news": $Content ="backend_showAllNews"; break;
      case "guestbook": $Content ="backend_showAllGuestbookEntries"; break;
      case "filesharing": $Content ="downloadMidiFiles"; break;
      case "user": $Content ="editCurrentUser"; break;
      case "mail": $Content ="mail"; break;
      case "admin": $Content ="setup"; break;
      case "cms": $Content ="menu"; break;
      case "help": $Content ="forum"; break;
    }
  }
  include ('includes/header.php');
  // include JavaScipt
    switch ( $Content ) {
      case "backend_addNews":
        include ('includes/editor.php');
        break;
      case "addPage":
        include ('includes/editor.php');
        break;
      case "backend_addGig":
        if (getSetup('SetupShowEditorInAddGigForm'))
          include ('includes/editor.php');
        include ('calendar/includes/addGig/javascript.php');
        include ('calendar/includes/addGig/autocomplete-wo-js.php');
        break;
      case "setup":
        include ('admin/includes/setup/javascript.php');
        break;
      case "addUser":
        include ('admin/includes/addUser/javascript.php');
        break;
      case "editCurrentUser":
        include ('admin/includes/addUser/javascript.php');
        break;
    }
  // Updating MySQL Datebase if update file is present
    if (is_file("update.sql.php")) include("update.sql.php");

    ?>
    </head>
  <body>
    <div id="Box">
      <div class="Head">
        <div class="Title"><img src="images/gigkalender-logo.gif" alt="GigKalender-Logo" /></div>
        <div class="Login">
          <?php
            echo $Message;
            include("includes/login.php");
          ?>
        </div>
      </div>
      <?php
        if (loggedIn())
	      {
          echo '<div id="Box_Navigation">';
          include("includes/menue.php");
          echo '<br style="clear: left;" />';
          if ($Submenue!="") { include "submenues/".$Submenue.".php"; }
          echo '<br style="clear: left;" />
            </div>
            <div id="Box_Inhalt">';
          if ($Content!="") { include($Submenue.'/'.$Content.'.php');
          echo '</div>'; }
        }
        echo '<br style="clear: left;" />';
      ?>
      <div id="Box_Footer">
        <?php include("includes/footer.php"); ?>
      </div>
    </div>
  </body>
</html>