<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/

$files = getFileNames($directory, $fileTypes);
$count = count($files); // Dateien zählen
if ( $count == 0) // no files present
  echo $L_036;
else {
  // check for bad characters in filenames
    $arrayBlanks = array();
    $arrayUpperCase = array();
    $arraySpecialCharacters = array();
    $arrayUmlauts = array();
    for ( $i=0; $i<$count; $i++) {
      if ( substr_count( $files[$i], ' ' )>0 )
        array_push($arrayBlanks, $files[$i]);
      if ( preg_match( '([A-Z])u', $files[$i] ) )
        array_push($arrayUpperCase, $files[$i]);
      if ( preg_match( '([/:\'{}()&+=])u', $files[$i] ) )
        array_push($arraySpecialCharacters, $files[$i]);
      if ( preg_match( '([äöüÄÖÜß])u', $files[$i] ) )
        array_push($arrayUmlauts, $files[$i]); }
    $countBlanks = count($arrayBlanks);
    $countUpperCase = count($arrayUpperCase);
    $countSpecialCharacters = count($arraySpecialCharacters);
    $countUmlauts = count($arrayUmlauts);
    $AnzahlFehler = $countBlanks+$countUpperCase+$countSpecialCharacters+$countUmlauts;
  
    if ( !isset($gesendet) ) { // Error Messages
      if ($countBlanks)
        echo '<span class="ErrorMessage">'.$L_196.' '.$arrayBlanks[0].'</span><br />';
      if ($countUpperCase)
        echo '<span class="ErrorMessage">'.$L_197.' '.$arrayUpperCase[0].'</span><br />';
      if ($countSpecialCharacters)
        echo '<span class="ErrorMessage">'.$L_198.' '.$arraySpecialCharacters[0].'</span><br />';
      if ($countUmlauts)
        echo '<span class="ErrorMessage">'.$L_199.' '.$arrayUmlauts[0].'</span><br />';
      if ( $AnzahlFehler ) {
        if ( IsUserAdmin() ) {
          echo '<form method="post" action="index.php?submenue=filesharing&amp;content='.$CurrentPage.'" accept-charset="UTF-8">
                  <fieldset>
                    <input type="hidden" name="gesendet" value="1" />
                    <input style="width:8em;" class="SmallButton" type="submit" value="'.$L_Rename.'" onclick="javascript:allAttributes()" />
                  </fieldset>
                </form><br />'; }}
    }
    else // Dateien umbenennen
    {
      $i = $count-1;
      while ($i>=0)
      {
        $oldFileName = $files[$i];
        //echo $oldFileName;
        if ($oldFileName != "." && $oldFileName != "..")
        {
          // UpperCase
          $newFileName = mb_strtolower( $oldFileName );
          // Blanks
          $newFileName = str_replace(" ", "-", $newFileName );
          // SpecialCharacters
          $search = array("&", "/", ":", "'", "{", "}", "(", ")", "&", "+", "=", "[", "]");
          $replace =array("", "", "", "", "", "", "", "", "", "", "", "", "");
          $newFileName = str_replace($search, $replace, $newFileName);
          // Umlauts
          $search = array("ß", "ä", "ö", "ü");
          $replace =array("ss", "ae", "oe", "ue");
          $newFileName = str_replace($search, $replace, $newFileName);
          // Specials
          $newFileName = str_replace("---", "_", $newFileName );
          $newFileName = str_replace("--", "_", $newFileName );
          $newFileName = str_replace("_-_", "_", $newFileName );
          // Rename file
          if ($newFileName!=$oldFileName) {
            if ($newFileName!=mb_strtolower( $oldFileName )) {
              $j=1;
              $FileType = strrchr ( $newFileName, '.');
              $temp = str_replace( $FileType, "", $newFileName);
              while ( file_exists ($directory.$newFileName) )
                $newFileName = $temp.'~'.$j++.$FileType; }
            if ( !rename( $directory.$oldFileName, $directory.$newFileName) )
              echo '<span class="ErrorMessage">'.$L_195.' '.$oldFileName.' ->'.$newFileName.'</span><br />';
            //echo ' > '.$newFileName;
            }
          $i--;
        }
        //echo '<br>';
      }
      $files = getFileNames($directory, $fileTypes);
    }
  // Table of files
  echo '<table>
          <tr>
            <th>'.$count.' '.$L_034.'</th>
            <th>'.$L_035.'</th>
          </tr>';
  for ( $i=0; $i<$count; $i++) {
    $fileSize = filesize($directory.$files[$i]);
    $fileSizeFormatted = formatFileSize($fileSize, 2);
    echo '<tr>
            <td><a href="'.$directory.$files[$i].'">'.$files[$i].'</a></td>
            <td class="TabellenSpalte_Rechts" style="text-align:right">'.$fileSizeFormatted.'</td>
          </tr>'; }
  echo '</table>';
}
?>