<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/

$Path = str_replace('\\','/', __FILE__);
$Path = str_replace('gallery/gallery.php', '', $Path);

include_once ($Path.'gigkalender.ini.php');
include_once ($Path.'includes/error_reporting.php');
include_once ($Path.'functions/standard.php');
include_once ($Path.'gallery/functions.php');
include_once ($Path."includes/frontend_language_selector.php");

$FrontendGalleryURL = getFrontendURL('SetupGalleryURL');
if (preg_match('|\?|', $FrontendGalleryURL))
  $FrontendGalleryURLquery = $FrontendGalleryURL.'&';
else
  $FrontendGalleryURLquery = $FrontendGalleryURL.'?';

if (isset($_REQUEST['gallery_page']))
  $FrontendGalleryURLquery.= 'gallery_page='.$_REQUEST['gallery_page'];

$AlbumsPath = $GigKalenderPath.'gallery/albums/';
$CachePath = $GigKalenderPath.'cache/gallery/albums/';
$AlbumsPathLocal = $Path.'gallery/albums/';
$CachePathLocal = $Path.'cache/gallery/albums/';

foreach ($_REQUEST as $key => $value) {
  $$key = $value; };

echo '<div class="GigKalender"><div id="Gallery">';
if (!isset($album)) { // Gallery
  $Albums = array();
  $ArrayOfAllAlbums = getArrayOfAllAlbums($AlbumsPathLocal);
  rsort ($ArrayOfAllAlbums);
  $AmountOfAlbums = count($ArrayOfAllAlbums);
  // Pagination
    $NumberOfEntries = $AmountOfAlbums;
    //$EntriesPerPage = getSetup('SetupNewsEntriesPerPage');
    $EntriesPerPage = 10;
    if ($EntriesPerPage!=0)
      $NumberOfPages = ceil($NumberOfEntries/$EntriesPerPage);
    else
      $NumberOfPages = 1;
    if (isset($_REQUEST['gallery_page']))
      $CurrentPage = $_REQUEST['gallery_page'];
    else
      $CurrentPage = $NumberOfPages;
    $NewsFrontendPagination = getGalleryFrontendPagination();
    if ($NumberOfPages>1)
      echo $NewsFrontendPagination;
  echo '<table summary="Gallery">';
  $TopEntry = ($NumberOfPages-$CurrentPage)*$EntriesPerPage;
  $LastEntry = $TopEntry+$EntriesPerPage;
  if ($LastEntry>$NumberOfEntries)
    $LastEntry=$NumberOfEntries;
  //echo $TopEntry.'-'.$LastEntry.'-'.$CurrentPage;
  for ($i=$TopEntry; $i<$LastEntry; $i++) {
    $Album = $ArrayOfAllAlbums[$i];
    $OriginalsPath = $AlbumsPathLocal.$Album.'/original'; // Bugfix: v1.2.83_035
    if (is_dir($OriginalsPath)) { // Bugfix v1.2.83_021
      $ArrayOfImages = getArrayOfImagesInFolder($Album.'/original');
      $AmountImagesInAlbum = count($ArrayOfImages);
      $ThumbnailID = rand(0,$AmountImagesInAlbum-1);
      $Filename = $ArrayOfImages[$ThumbnailID];
      $AlbumThumbnailPath = $CachePath.$Album.'/thumbnails/'.$Filename;
      $AlbumThumbnailPathLocal = $CachePathLocal.$Album.'/thumbnails/'.$Filename;
      if (!file_exists($AlbumThumbnailPathLocal)) {
        scaleImage($Album, 'thumbnails', $Filename); }
      $AlbumURL = $FrontendGalleryURLquery.'&album='.$Album;
      // set album Title
      if (file_exists($AlbumsPathLocal.$Album.'/title.txt'))
        $AlbumTitle = getTextFile ( $Album, 'title', '' );
      else
        $AlbumTitle = $Album;
      // set album Description
      if (file_exists($AlbumsPathLocal.$Album.'/description.txt'))
        $AlbumDescription = getTextFile ( $Album, 'description', '' );
      else
        $AlbumDescription = '';
      ob_start();
      include($Path.'gallery/templates/gallery_entry.php');
      $GalleryEntry = ob_get_contents();
      ob_end_flush();
      array_push ($Albums, $GalleryEntry); }
    else {
      echo '<span class="ErrorMessage">ERROR: Missing folder <i>original</i> in album <i>'.$Album.'</i>)!</span><br>'; }
     }
  echo '</table>';
  if ($NumberOfPages>1)
    echo $NewsFrontendPagination; }
else { // Album
  $ImageDirectory = $AlbumsPath.$album.'/original/';
  $ThumbnailDirectory = $CachePath.$album.'/thumbnails/';
  $TextDirectory = $AlbumsPath.$album.'/text/';
  $ArrayOfImagesInFolder = getArrayOfImagesInFolder ( $album.'/original/' );
  $AnzahlBilder = count($ArrayOfImagesInFolder);
  if (!isset($image)) { //Album
    $IconGallery = '<a href="'.$FrontendGalleryURLquery.'"><img src="'.PATH.'gallery/images/gallery.gif" alt="'.$L_Back_to_gallery.'" title="'.$L_Back_to_gallery.'" /></a>';
    $AlbumDescription = getTextFile ( $album, 'description', '' );
    // set album Title
      if (file_exists($AlbumsPathLocal.$album.'/title.txt'))
        $AlbumTitle = getTextFile ( $album, 'title', '' );
      else $AlbumTitle = $album;
      //$AlbumTitle = getTextFile ( $album, 'title', '' );
    // Thumbnails
    $Thumbnails = array();
    for ($i=0; $i<$AnzahlBilder; $i++) {
      $ThumbnailFileName = $ArrayOfImagesInFolder[$i];
      if (!file_exists($CachePathLocal.$album.'/thumbnails/'.$ThumbnailFileName)) {
        scaleImage ( $album, 'thumbnails', $ThumbnailFileName ); }
      //ob_start();
      $Text = getTextFile ( $album, 'image', $ArrayOfImagesInFolder[$i] );
      //ob_end_flush();
      array_push ($Thumbnails, '<a href="'.$FrontendGalleryURLquery.'&album='.$album.'&image='.$i.'"><img src="'.$ThumbnailDirectory.$ThumbnailFileName.'" alt="'.$Text.'" title="'.$Text.'" /></a>'); }
    include_once ($Path.'gallery/templates/album.php'); }
  else { // Einzelbild
    // For pagination
      //$GalleryURL = $FrontendGalleryURL.'?gallery_page='.$_REQUEST['gallery_page'];
      //echo $FrontendGalleryURLquery;
      //echo '<br>';
      //echo $GalleryURL;
      $AlbumURL = $FrontendGalleryURLquery.'&album='.$album;
    $IconGallery = '<a href="'.$FrontendGalleryURLquery.'"><img src="'.PATH.'gallery/images/gallery.gif" alt="'.$L_Back_to_gallery.'" title="'.$L_Back_to_gallery.'" /></a>';
    $IconAlbums = '<a href="'.$AlbumURL.'"><img src="'.PATH.'gallery/images/album.gif" alt="'.$L_Back_to_album.'" title="'.$L_Back_to_album.'" /></a>';
    if ($image>0) {
      $IconFirst = '<a href="'.$AlbumURL.'&image=0"><img src="'.PATH.'gallery/images/first.gif" alt="'.$L_First.'" title="'.$L_First.'" /></a>';
      $IconPrevious = '<a href="'.$AlbumURL.'&image='.($image-1).'"><img src="'.PATH.'gallery/images/previous.gif" alt="'.$L_Previous.'" title="'.$L_Previous.'" /></a>'; }
    else {
      $IconFirst = '<img src="'.PATH.'gallery/images/first_deactive.gif" alt="" />'; // Bugfix v1.2.78_041
      $IconPrevious = '<img src="'.PATH.'gallery/images/previous_deactive.gif" alt="" />'; }
    if ($image<$AnzahlBilder-1) {
      $IconLast = '<a href="'.$AlbumURL.'&amp;image='.($AnzahlBilder-1).'"><img src="'.PATH.'gallery/images/last.gif" alt="'.$L_Last.'" title="'.$L_Last.'" /></a>';
      $IconNext =  ' <a href="'.$AlbumURL.'&amp;image='.($image+1).'"><img src="'.PATH.'gallery/images/next.gif" alt="'.$L_Next.'" title="'.$L_Next.'" /></a>'; }
    else {
      $IconLast = '<img src="'.PATH.'gallery/images/last_deactive.gif" alt="" />'; // Bugfix v1.2.78_041
      $IconNext =  ' <img src="'.PATH.'gallery/images/next_deactive.gif" alt="" />'; }
    //print_r($ArrayOfImagesInFolder);
    $ImageFileName = $ArrayOfImagesInFolder[$image];
    $Original = checkIfOriginalIsPresent($album, $ImageFileName);
    if ( $Original ) $IconLens = '<a href="'.$AlbumsPath.$album.'/original/'.$Original.'"><img src="'.PATH.'gallery/images/lens.gif" alt="'.$L_Magnify.'" title="'.$L_Magnify.'" /></a>';
      else $IconLens = '<img src="'.PATH.'gallery/images/lens_deactive.gif" alt="" title="" />';
    $AmountOfImages = $AnzahlBilder;
    $NumberOfCurrentImage = $image+1;
    // set album Title
    if (file_exists($AlbumsPathLocal.$album.'/title.txt'))
      $AlbumTitle = getTextFile ( $album, 'title', '' );
    else
      $AlbumTitle = $album;
    //$AlbumURL = $FrontendGalleryURLquery.'?gallery='.$album;
    // Image
    $Text = getTextFile ( $album, 'image', $ImageFileName );
    if (!file_exists($CachePathLocal.$album.'/images/'.$ImageFileName)) {
      scaleImage ( $album, 'images', $ImageFileName ); }
    $ImageDirectory = $CachePath.$album.'/images/';
    if ($Text=="")
      $Title = $ImageFileName;
    else
      $Title = $Text;
    $Image = '<img src="'.$ImageDirectory.$ImageFileName.'" alt="'.$Title.'" title="'.$Title.'" id="Image" />';
    // Text
    if ($Text!==NULL) // Bugfix v1.2.83_017
      $Text = nl2br($Text);
    include_once ($Path.'gallery/templates/image.php'); }}
echo '</div></div>';
?>

