<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/
  header("content-type: text/html; charset=utf-8");
  include('head.php');

  echo '<body>
    <div id="Install">
      <div class="Head">
        <div class="Title"><img src="../images/gigkalender-logo.gif" alt="GigKalender-Logo" /></div>
      </div>
      <p class="Headline">'.$L_Headline39.'</p>';
      clearCache ();
      $Install = TRUE;
      // Determine PHP Version
      echo 'PHP-Version: '.PHP_VERSION;
      if (version_compare(PHP_VERSION, '8.0.0') >= 0)
        echo ' <img src="../images/exist.gif" /><br>';
      else {
        echo ' <img src="../images/dontexist.gif" /><br>';
        $Install = FALSE; }
      // Check if PHP module GD is enabled
      echo "Module <i>gd</i> enabled: ";
      $EnabledModules = get_loaded_extensions();
      if (in_array('gd', $EnabledModules, TRUE))
        echo ' <img src="../images/exist.gif" /><br>';
      else {
        echo ' <img src="../images/dontexist.gif" /><br>';
        $Install = FALSE; }
      // Check if PHP module MB is enabled
      echo "Module <i>mbstring</i> enabled: ";
      $EnabledModules = get_loaded_extensions();
      if (in_array('mbstring', $EnabledModules, TRUE))
        echo ' <img src="../images/exist.gif" /><br>';
      else {
        echo ' <img src="../images/dontexist.gif" /><br>';
        $Install = FALSE; }
      // Determine SQL Server Version
      $SQLServerInfo = mysqli_get_server_info($db);
      //$SQLServerInfo = "5.7.36-log";
      //$SQLServerInfo = "5.70.36-log";
      //$SQLServerInfo = "5.5.5-10.4.20-MariaDB";
      //$SQLServerInfo = "xxx";
      if (strpos($SQLServerInfo, 'MariaDB', 0)) { // MariaDB, e.g. 10.4.24-MariaDB
        $DatabaseServer = "MariaDB";
        $snippets = explode("-", $SQLServerInfo);
        $hyphens = count($snippets)-1; // How many - in name
        //echo $hyphens;
        if ($hyphens==1) // new style: 10.4.24-MariaDB
          $SQLVersion = $snippets[0];
        elseif ($hyphens==2) // old style: 5.5.5-10.4.20-MariaDB
          $SQLVersion = $snippets[1];
        echo "SQL Version: ".$SQLServerInfo;
        if (version_compare($SQLVersion, '10.0.0') >= 0)
          echo ' <img src="../images/exist.gif" /><br>';
        else {
          echo ' <img src="../images/dontexist.gif" /><br>';
          $Install = FALSE; }}
      else if (strpos($SQLServerInfo, 'log', 0)) { // MySQL, e.g. 5.7.36-log
        $DatabaseServer = "MySQL";
        $pos = strpos($SQLServerInfo, '-', 0);
        $SQLVersion = substr($SQLServerInfo, 0, $pos);
        echo "SQL Version: ".$SQLServerInfo;
        if (version_compare($SQLVersion, '5.5.0') >= 0)
          echo ' <img src="../images/exist.gif" /><br>';
        else {
          echo ' <img src="../images/dontexist.gif" /><br>';
          $Install = FALSE; }}
      else {
        $DatabaseServer = "unknown";
        $SQLVersion = "unknown";
        $Install = FALSE; }
      // Installation
      if ($Install) {
        $installationOK = true;
        if (!isDatabasePresent()) {
          $SQLQuery = 'CREATE DATABASE `'.$db_name.'`';
          $Result = mysqli_query($db, $SQLQuery);
          if (!$Result) {
            echo '<span class="ErrorMessage">'.$L_ERROR_Database_not_found.' ('.$db_name.')('.__LINE__.')</span><br><br>';
            die('<span class="ErrorMessage">'.$L_ERROR.': '. mysqli_error($db).'('.__LINE__.')</span><br');
            $installationOK = false; }
          else {
            echo $L_Database_added.'<br>';
            include ('iniTables.php'); }}
        else {
          echo $L_Found_Database.'<br>';
          include ('iniTables.php'); }}
      else {
        echo '<span class="ErrorMessage">'.$L_ERROR_Wrong_MySQL_Version.' ('.$SQLVersion.')</span><br>';
        $installationOK = false; }
      //Ergebnis der Installation ausgeben
      if ($installationOK) {
        echo '<br><br><b>'.$L_Installation_successful.'</b><br>
              <br>
              <form method="post" action="index3.php" accept-charset="UTF-8">
                <fieldset>
                  <input type="submit" value="'.$L_Button26.'" class="button" />
                </fieldset>
              </form>'; }
      else {
        echo '<br><span class="ErrorMessage">'.$L_ERROR_Installation_failed.' </span><br>'; }
      include ('../includes/footer.php');
    echo '</div>
  </body>
</html>';  ?>
