<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/
  $Path = str_replace('\\','/', __FILE__);
  $Path = str_replace('calendar/month.php', '', $Path);

  include_once($Path."gigkalender.ini.php");
  include_once($Path."functions/standard.php");
  include_once($Path."includes/frontend_language_selector.php");
  
  if (isset($_REQUEST['month'])) { $Month=$_REQUEST['month']; }
    else { $Month = date("n"); }
  if (isset($_REQUEST['year'])) { $Year=$_REQUEST['year']; }
    else { $Year = date("Y"); }
  if (isset($_REQUEST['GigID']))
  {
    $Timestamp = getGigVarFromGigID ($_REQUEST['GigID'], 'GigDate');
    $Month=date("n", $Timestamp);
    $Year=date("Y", $Timestamp);
  }

  $FirstDayOfTheWeek = getWeekdayFromDate(1, $Month, $Year);
  $TimestampOfToday = getTimestampFromDate(date("d"), date("m"), date("y"));
  $Day = 1;
  $Cell = 1;
  $getDaysOfAMonth = getDaysOfAMonth($Month, $Year);
  
  $MonthBackwards = $Month-1;
  $YearBackwards = $Year;
  if ( $MonthBackwards == '0') 
  {
    $MonthBackwards = '12';
    $YearBackwards  = $Year-1;
  }
  $MonthForwards = $Month+1;
  $YearForwards = $Year;
  if ( $MonthForwards == '13') 
  {
    $MonthForwards = '1';
    $YearForwards  = $Year+1;
  }
  // Kalender-Grenzen bestimmen
    $TimestampOfFirstDayOfShownMonth = getTimestampFromDate(1, $Month, $Year);
    // Limit der Vergangenheit bestimmen
      $LimitPastMonth = date("m")-$SetupFrontendCalendarCurrentMonthLimitPast;
      $LimitPastYear = date("y");
      if ($LimitPastMonth<1)
      {
        $LimitPastMonth = $LimitPastMonth+12;
        $LimitPastYear--;
      }
    // Limit der Zukunft bestimmen
      $LimitPast = getTimestampFromDate(1, $LimitPastMonth, $LimitPastYear);
      $LimitFutureMonth = date("m")+$SetupFrontendCalendarCurrentMonthLimitFuture;
      $LimitFutureYear = date("y");
      if ($LimitFutureMonth>12)
      {
        $LimitFutureMonth = $LimitFutureMonth-12;
        $LimitFutureYear++;
      }
      $LimitFuture = getTimestampFromDate(1, $LimitFutureMonth, $LimitFutureYear);
  echo '<div id="CalendarCurrentMonth">
        <table summary="CalendarCurrentMonth">
          <tr>';
  // URL bestimmen
    $URL = getFrontendURL ('SetupFrontendCalendarCurrentMonthURL');
    //echo "---".$URL."---<br/>";
  echo '<td class="NavigationBackwards"><a href="'.$URL.'?year='.$YearBackwards.'&amp;month='.$MonthBackwards.'">';
  if ($TimestampOfFirstDayOfShownMonth>$LimitPast) echo '&laquo;';
    else echo ' ';
  echo '</a></td>
            <td colspan="5"><span class="Month">'.getNameOfMonthFromNumberOfMonth ($Month).' '.$Year.'</span></td>
            <td class="NavigationForwards"><a href="'.$URL.'?year='.$YearForwards.'&amp;month='.$MonthForwards.'">';
  if ($LimitFuture>$TimestampOfFirstDayOfShownMonth) echo '&raquo;';
    else echo ' ';
  echo '</a></td>
          </tr>
          <tr id="Weekdays">
            <td>'.$L_Mo.'</td>
            <td>'.$L_Tu.'</td>
            <td>'.$L_We.'</td>
            <td>'.$L_Th.'</td>
            <td>'.$L_Fr.'</td>
            <td>'.$L_Sa.'</td>
            <td>'.$L_Su.'</td>
          </tr>
          <tr>';
          
  for ($z=1; $z<=6 AND $Day <= $getDaysOfAMonth; $z++) {
    for ($s=1; $s<=7; $s++) {
      if (($Cell < $FirstDayOfTheWeek) OR ($Day > $getDaysOfAMonth)) {echo "<td></td>";}
      else {
        $Timestamp = getTimestampFromDate($Day, $Month, $Year);
        if ( !DatumInZukunft($Timestamp) AND !$SetupFrontendCalendarCurrentMonthShowPastGigs )
          $PublishedGigPresent = false;
        else
          $PublishedGigPresent = publishedGigOnTimestamp($Timestamp);
        echo '<td>';
        echo '<div class="'.WochentagsNameVonDatum ($Day, $Month, $Year).'">';
        if ($Timestamp == $TimestampOfToday) { echo '<span class="Today">'; }

        // Wochentags-Zahl mit Link
        if (!$PublishedGigPresent)
          echo $Day;
        else {
          echo '<div class="Gig">';
          $ToolTip = getTooltip($Timestamp);
          $URL = getFrontendURL('SetupFrontendCalendarGigDetailsURL');
          //$URL .= '&amp;year='.$Year.'&amp;month='.$Month;
          echo '<form style="margin: 0; padding: 0; display: inline;" id="form'.$Timestamp.'" method="post" action="'.$URL.'" accept-charset="UTF-8">
                  <p style="margin: 0; padding: 0; display: inline;" title="'.$ToolTip.'">
                    <input type="hidden" name="timestamp" value="'.$Timestamp.'" />
                    <a href="'.$URL.'" onclick="javascript:document.forms[\'form'.$Timestamp.'\'].submit()">'.$Day.'</a>
                  </p>
                </form>';
          echo '</div>';
        }
        if ($Timestamp == $TimestampOfToday) echo "</span>";
        echo "</div>";
        echo "</td>\n";
        $Day++;
      }
      if ($s == "7") {
        if ($z < "6" AND $Day <= $getDaysOfAMonth)
          echo "</tr><tr>";
        else
          echo "</tr>";
      }
      $Cell++;
    }
  }
  echo '</table></div>';
?>