<?php
/*
    CREATIVE COMMONS - Attribution-No Derivative Works 3.0 Germany:
    - You may not alter, transform, or build upon this work.
    - Dieses Werk darf nicht bearbeitet oder in anderer Weise verändert werden.
*/
include ("../includes/error_reporting.php");
header("content-type: text/html; charset=utf-8");
include ("../gigkalender.ini.php");
include ("../functions/standard.php");
include ('install_language_selector.php');
include ('head.php');

function checkTableExists(string $table):bool {
// Inspired by https://www.php.net/manual/en/mysqli-driver.report-mode.php
global $db, $prefix;
  try {
    $result = mysqli_query($db, "SELECT * FROM ".$prefix.$table);
    return true; }
  catch (mysqli_sql_exception $e) {
    return false; }}

function dropTable(string $table):int {
  if (checkTableExists($table)) {
    global $db, $prefix, $L_Table_deleted;
    $SQLQuery = "DROP TABLE IF EXISTS ".$prefix.$table;
    if (mysqli_query($db, $SQLQuery)) {
      echo $L_Table_deleted.' ('.$table.')<br />';
      return 1; }
    else {
      echo '<span class="ErrorMessage">ERROR: Dropping table failed! ('.$table.')</span><br>';
      return -1; }}
  else {
    echo 'Table <i>'.$table.'</i> doesn\'t exist!<br>';
    return 0; }}

  echo '</head><body>
    <div id="Install">
      <div class="Head">
        <div class="Title"><img src="../images/gigkalender-logo.gif" alt="GigKalender-Logo" /></div>
      </div>
      <p class="Headline">'.$L_Headline37.'</p>';
      
      $timer = startTime();
      if (isset($_POST['uninstall']))
      {
        if ($_POST['uninstall']==$L_Button23)
        {
          if ( isDatabasePresent() )
          {
            $tables = array('gigs', 'user', 'setup', 'guestbook', 'news', 'menu');
            //$count = count($tables);
            $Dropped = 0;
            $Errors = 0;
            foreach ($tables as &$value) {
              $result = dropTable($value);
              switch($result) {
                case  1: $Dropped++; break;
                case  0: ; break;
                case -1: $Errors++; break;
                default: echo "ERROR!<br>"; }}
            //echo $count.'-'.$success.'-'.$Errors.'<br>';
            echo '<br>';
            if ($Dropped>0 AND $Errors===0)
              echo '<b>'.$L_Uninstallation_successful.'</b><br>';
            elseif ($Dropped===0 AND $Errors===0)
              echo '<b>GigKalender wasn\'t installed!</b><br>';
            else
              echo '<span class="ErrorMessage">Uninstallation failed!</span><br>';
          }
          else { echo '<span class="ErrorMessage">'.$L_ERROR_No_installation_of_gigkalender_present.'</span><br />'; }
        }
        if ($_POST['uninstall']=="Nein")
        {
          echo '<span class="ErrorMessage">'.$L_ERROR_GigKalender_not_uninstalled.'</span><br />';
        }
      }
      else
      {
        echo $L_Are_you_sure_you_want_to_uninstall_gigkalender.'<br /><br />';
        echo '<span class="ErrorMessage">'.$L_WARNING_all_data_will_be_deleted.'</span><br /><br />';
        echo '
          <form method="post" action="uninstall.php" accept-charset="UTF-8">
            <fieldset>
              <input name="uninstall" type="submit" value="'.$L_Button23.'" class="button" />
              <input name="uninstall" type="submit" value="'.$L_Button24.'" class="button" />
            </fieldset>
          </form>
        ';
      }
      include ('../includes/footer.php');
    echo '</div></body></html>'; ?>
