<?php
/*
    CREATIVE COMMONS - Attribution-NoDerivs 3.0 Germany (CC BY-ND 3.0)
      No Derivative Works: You may not alter, transform, or build upon this work.
      http://creativecommons.org/licenses/by-nd/3.0/de/deed.en
*/

  function getCSVToArray ()
  {
    $row = 1;
    $Array = array();
    if (($handle = fopen("includes/versions.csv", "r")) !== FALSE)
    {
      while (($line = fgetcsv($handle, 1000, ",")) !== FALSE)
      {
        if (isset($line[1]))
        {
          if (!isset($line[2]))
            $Array[$line[0]] = array($line[1], '');
          else
            $Array[$line[0]] = array($line[1], $line[2]);
        }
        else
          $Array[$line[0]] = array('', '');
        $row++;
      }
      fclose($handle);
    }
    return $Array;
  }
  function showProgressBar ($i, $StartTimestamp)
  {
    global $Debug;
    if (!$Debug)
    {
      echo '.';
      if (is_int(($i+1)/100)) echo (time()-$StartTimestamp). ' seconds over<br />';
    }
  }

  function getFilesInProject ($strDir, $Files)
  {
    if (is_dir($strDir))
    {
      if (substr($strDir, strlen($strDir)-1 )!="/") $strDir.='/';
      $oDir = dir( $strDir );
      while (false!==($strFile=$oDir->read()))
      {
        if ($strFile!='.' && $strFile!='..' && !is_link($strDir.$strFile))
        {
          if (is_file($strDir.'/'.$strFile))
          {
            if (stristr($strFile, '.php')!==FALSE) $Files[] = $strDir.$strFile;
          }
          else
          {
            if(is_dir($strDir.$strFile))
            {
              $Files = getFilesInProject($strDir.$strFile.'/', $Files);
            }
          }
        }
      }
      $oDir->close();
    }
    elseif (is_file($strDir))
    {
      if (stristr($strDir, '.php')!==FALSE) $Files[] = $strDir;
    }
    else
    {
      echo 'ERROR: '.$strDir.' not found!<br />';
    }
    return $Files;
  }

  function getPHPFunctionsArray ()
  {
    $PHPFunctionsArray = file('includes/phpFunctions.php');
    $countFunctions = count($PHPFunctionsArray);
    // Remove spaces from each array element
      for ($i=0; $i<$countFunctions; $i++ )
      {
        $PHPFunctionsArray[$i] = trim ( $PHPFunctionsArray[$i] );
      }
    // Delete Empty Elements
      for ($i=0; $i<$countFunctions; $i++ )
      {
        if ($PHPFunctionsArray[$i]== "") unset ( $PHPFunctionsArray[$i] );
      }
      // remove the gaps into the array keys
        $PHPFunctionsArray = array_values($PHPFunctionsArray);
    return $PHPFunctionsArray;
  }

?>