<?php
/*
    CREATIVE COMMONS - Attribution-NoDerivs 3.0 Germany (CC BY-ND 3.0)
      No Derivative Works: You may not alter, transform, or build upon this work.
      http://creativecommons.org/licenses/by-nd/3.0/de/deed.en
*/
  // http://php.net/quickref.php
  // http://regexp-evaluator.de/tutorial/metazeichen/

  header("content-type: text/html; charset=utf-8");
  error_reporting(E_ALL);
  $StartTimestamp = time();
  ob_end_flush();
  if( ini_get('safe_mode') )
  {
    echo '<div class="DarkOrange">PHP is not running Safe Mode! This script might stop running soon...</div><br />';
  }
  else
  {
    @set_time_limit (9999);
  }

  include ('psv-elicitor.ini.php');
  include ('includes/functions.php');

  echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
          <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
            <head>
              <meta http-equiv="content-type"	content="text/html;charset=utf-8" />
              <meta http-equiv="Content-Style-Type" content="text/css" />
              <meta name="robots" content="noindex,nofollow" />
              <link rel="stylesheet" type="text/css" media="screen, print" href="psv-elicitor.css" />
              <link rel="shortcut icon" href="favicon.ico" />
              <title>PSV Elicitor</title>
            </head>
            <body>
              <div>
              <h1>PSV Elicitor</h1>';

  // Read functions list
    $Functions = getPHPFunctionsArray ();
  // Create files array
    $Files = getFilesInProject ($Directory, array());
  $countFiles = count($Files);
  if ($countFiles>0)
  {
    echo '<h2>'.$countFiles.' PHP file(s) found</h2> in '.$Directory.'<br />';
    flush();
    // Check If Functions Names As Strings Are Used In Files
      $FilesWithFunctionString = array();
      echo '<h2>Searching file(s) containing PHP function names as strings:</h2>';
      flush();
      $countFiles = count($Files);
      for ($i=0; $i<$countFiles; $i++ )
      {
        $shortFilePath = str_replace($Directory, '', $Files[$i]);
        if ($DebugMode) echo '&nbsp;&nbsp;&nbsp;&nbsp;['.str_pad($i, strlen($countFiles-1) , '0', STR_PAD_LEFT).'] <b>'.$shortFilePath.':</b>';
        if ($ignoreComments==TRUE) $FileString = php_strip_whitespace($Files[$i]);
          else $FileString = file_get_contents($Files[$i]);
        $countFunctions = count($Functions);
        for ($j=0; $j<$countFunctions; $j++ )
        {
          if (stristr($FileString, $Functions[$j])!==FALSE)
          {
            $FilesWithFunctionString[] = $Files[$i];
            if ($DebugMode) echo ' String <i>'.$Functions[$j].'</i> found.';
            break;
          }
        }
        if ($DebugMode) echo '<br />';
        if (!$DebugMode) showProgressBar ($i, $StartTimestamp);
        //if ($DebugMode) echo '<br />';
        flush();
      }
      // Remove double entries
        $FilesUnique = array_unique($FilesWithFunctionString);
      // remove the gaps into the array keys
        $Files2 = array_values($FilesUnique);
      echo '<br />'.count($Files2).' file(s) with function names as string found after '.(time()-$StartTimestamp).' seconds<br />';
    // Check if functions are used in script
      echo '<h2>Scanning file(s) for PHP function names as function:</h2>';
      flush();
      $UsedFunctionsInScript = array();
      $countFiles2 = count($Files2);
      for ($i=0; $i<$countFiles2; $i++ )
      {
        $shortFilePath = str_replace($Directory, '', $Files2[$i]);
        if ($ignoreComments==TRUE) $FileString = php_strip_whitespace($Files[$i]);
          else $FileString = file_get_contents($Files[$i]);
        $FileString = php_strip_whitespace($Files[$i]);
        $FileString = str_replace(' ', '', $FileString);
        $FileString = str_replace('<?php', '', $FileString);
        $FileString = preg_replace("/\n\r|\r\n|\n|\r/", "", $FileString);
        $countFunctions = count($Functions);
        for ($j=0; $j<$countFunctions; $j++ )
        {
          $stripos = stripos($FileString, $Functions[$j]);
          if ($stripos!==FALSE)
          {
            $Matches = array();
            preg_match_all('/'.$Functions[$j].'/i', $FileString, $Matches, PREG_OFFSET_CAPTURE);
            $countMatches = count($Matches[0]);
            for ($k=0; $k<$countMatches; $k++)
            {
              $strlen = strlen($Functions[$j]);
              $stripos2 = $Matches[0][$k][1];
              $leftPos = $stripos2-1;
              $rightPos = $stripos2+$strlen;
              $leftChar = substr($FileString, $leftPos, 1);
              $rightChar = substr($FileString, $rightPos, 1);
              $nextChar = substr($FileString, $rightPos+1, 1);
              // Delimiter = |
              $validCharsLeft = '/(\n|<|>|\=|\!|\@|\.|\(|\;|\{|\})/i';
              $validCharsRight = '/\(|\;|\'|\"|\$/i';
              $validCharsNext = '/\(/i';
              if ($DebugMode)
              {
                echo '&nbsp;&nbsp;&nbsp;&nbsp;';
                echo '['.str_pad($i, strlen($countFiles-1) , '0', STR_PAD_LEFT).']';
                echo ' <b>'.$shortFilePath.':</b> '.$stripos2.': |'.$leftChar.'<span class="LightGray">'.$Functions[$j].'</span>'.$rightChar.$nextChar.'|';
              }
              if (preg_match($validCharsLeft, $leftChar) AND preg_match($validCharsRight, $rightChar))
              {
                if  ( $leftChar==" " AND $rightChar==" " AND !preg_match($validCharsNext, $nextChar) )
                {
                  if ($DebugMode) echo ' <span style="background-color: red">Exception!</span>';
                }
                else
                {
                  if ($DebugMode) echo ' <span class="LimeGreen">This is a PHP function call!</span>';
                  $UsedFunctionsInScript[] = $Functions[$j];
                  if ($searchFirstOccurrenceOnly)
                  {
                    if ($DebugMode) echo '<br />';
                    break; // leaves the for-loop if function was found
                  }
                }
              }
              else if ($DebugMode) echo ' <span style="background-color: orange">This is NOT a PHP function call!</span>';
              if ($DebugMode) echo '<br />';
            }
          }
        }
        if (!$DebugMode) showProgressBar ($i, $StartTimestamp);
        flush();
      }
      // Remove double entries
        $UsedFunctionsInScript = array_unique($UsedFunctionsInScript);
      // remove the gaps into the array keys
        $UsedFunctionsInScript = array_values($UsedFunctionsInScript);
      // alphabetisch sortieren
        sort($UsedFunctionsInScript);
      echo '<br />'.count($Files2).' file(s) scanned after '.(time()-$StartTimestamp).' seconds<br />';
    // Output Of Results
      $countUsedFunctionsInScript = count($UsedFunctionsInScript);
      if ($countUsedFunctionsInScript==0)
        echo '<h2>No PHP functions found in this project!</h2>';
      else
      {
        echo '<h2>'.$countUsedFunctionsInScript.' PHP functions used in project:</h2>';
        for ($i=0; $i<$countUsedFunctionsInScript; $i++ )
        {
          echo $UsedFunctionsInScript[$i].', ';
        }
        // Calculate Version
          $FunctionsTable = getCSVToArray ();
          echo '<h2>Calculating PHP Version:</h2>';
          $LowerVersionLimit = 0;
          $UpperVersionLimit = 0;
          $FunctionsNotInTable = array();
          $DeprecatedFunctionsInProject = array();
          for ($i=0; $i<$countUsedFunctionsInScript; $i++ )
          {
            $Name = $UsedFunctionsInScript[$i];
            if (array_key_exists($Name, $FunctionsTable))
            {
              $LowerVersion = $FunctionsTable[$Name][0];
              $UpperVersion = $FunctionsTable[$Name][1];
              if ($LowerVersion!='')
              {
                if ($LowerVersion>$LowerVersionLimit) $LowerVersionLimit=$LowerVersion;
                if ($UpperVersion>$UpperVersionLimit) $UpperVersionLimit=$UpperVersion;
                if ($UpperVersion!='') $DeprecatedFunctionsInProject[] = $UsedFunctionsInScript[$i];
                if ($DebugMode)
                {
                  echo '&nbsp;&nbsp;&nbsp;&nbsp;['.$i.'] <b>'.$UsedFunctionsInScript[$i].':</b> '.$LowerVersion;
                  if ($UpperVersion!='') echo ' - '.$UpperVersion.' <span style="background-color:orange">Deprecated!</span>';
                  echo '<br />';
                }
              }
            }
            else
            {
              if ($DebugMode) echo '&nbsp;&nbsp;&nbsp;&nbsp;['.$i.'] <b>'.$Name.'</b>: <span style="background-color:orange">not in Table</span><br />';
              $FunctionsNotInTable[] = $Name;
            }
            if (!$DebugMode) showProgressBar ($i, $StartTimestamp);
          }
          echo '<br />';
          // Give out those functions not in version table
            $countFunctionsNotInTable = count($FunctionsNotInTable);
            if ($countFunctionsNotInTable)
            {
              echo '<h2>Missing definitions in includes/versions.csv:</h2>';
              for ($i=0; $i<$countFunctionsNotInTable; $i++ )
              {
                echo '<a href="http://php.net/manual/de/function.'.str_replace("_", "-", $FunctionsNotInTable[$i]).'.php">'.$FunctionsNotInTable[$i].'</a>, ';
              }
            }
            echo '<div class="LimeGreen"><h2>Result:</h2>
            <b>This project needs a PHP Version '.$LowerVersionLimit.' or higher.</b><br />';
          // Output Of Deprecated Functions In Project
            $countDeprecatedFunctionsInProject = count($DeprecatedFunctionsInProject);
            if ($countDeprecatedFunctionsInProject>0)
            {
              echo '<div class="DarkOrange"><b>This project uses functions which are depricated since PHP Version '.$UpperVersionLimit.':</b><br />';
              for ($i=0; $i<$countDeprecatedFunctionsInProject; $i++ )
              {
                echo '<a href="http://php.net/manual/de/function.'.str_replace("_", "-", $DeprecatedFunctionsInProject[$i]).'.php">'.$DeprecatedFunctionsInProject[$i].'</a>, ';
              }
              echo '</div>';
            }
            echo '</div>';
      }
  }
  else echo '<b>No PHP files found in</b> '.$Directory.'<br />';
  echo '<div id="Footer">PSV Elicitor v0alpha23 - ['.(time()-$StartTimestamp).' s]<br />
    <a rel="license" href="http://www.paderdesign.de/">
      <img alt="PaderDesign" title="PaderDesign" src="images/paderdesign.png" longdesc="http://www.paderdesign.de" />
    </a>
    <a rel="license" href="http://creativecommons.org/licenses/by-nd/3.0/de/deed.en">
      <img alt="Creative Commons License" title="Creative Commons License" src="images/creativecommons.png" />
    </a>
    </div>
    </div>
  </body>
</html>';
?>
