<?php
/*
    CREATIVE COMMONS - Attribution-NoDerivs 3.0 Germany (CC BY-ND 3.0)
      No Derivative Works: You may not alter, transform, or build upon this work.
      http://creativecommons.org/licenses/by-nd/3.0/de/deed.en
*/

function getPHPFunctionsArray($defFunctions):array {
  $PHPFunctionsArray = file($defFunctions);
  $countFunctions = count($PHPFunctionsArray);
  // Remove spaces from each array element
  for ($i=0; $i<$countFunctions; $i++ ) {
    $PHPFunctionsArray[$i] = trim ( $PHPFunctionsArray[$i] ); }
  // Delete Empty Elements
  for ($i=0; $i<$countFunctions; $i++ ) {
    if ($PHPFunctionsArray[$i]== "")
      unset ( $PHPFunctionsArray[$i] ); }
  // remove the gaps into the array keys
  $PHPFunctionsArray = array_values($PHPFunctionsArray);
  return $PHPFunctionsArray; }

function showProgressBar($i, $StartTimestamp):void {
  global $Debug;
  if (!$Debug) {
    echo '.';
    if (($i + 1) % 100 === 0)
      echo (time()-$StartTimestamp). ' seconds passed<br>'; }}

function getCSVToArray():array {
  $array = array();
  if (($handle = fopen("includes/versions.csv", "r")) !== FALSE) {
    while (($line = fgetcsv($handle, 1000, ",", "\"", "\\")) !== FALSE) {
      if (isset($line[1])) {
        if (!isset($line[2]))
          $array[$line[0]] = array($line[1], '');
        else
          $array[$line[0]] = array($line[1], $line[2]); }
      else
        $array[$line[0]] = array('', ''); }
    fclose($handle); }
  else {
    echo "ERROR: Can't open includes/versions.csv!"; }
  return $array; }

function getFilesInProject($strDir, $Files) {
  global $fileType;
  if (is_dir($strDir)) {
    if (substr($strDir, strlen($strDir)-1 )!="/") $strDir.='/';
    $oDir = dir( $strDir );
    while (false!==($strFile=$oDir->read()))
    {
      if ($strFile!='.' && $strFile!='..' && !is_link($strDir.$strFile))
      {
        if (is_file($strDir.'/'.$strFile))
        {
          if (stristr($strFile, $fileType)!==FALSE) $Files[] = $strDir.$strFile;
        }
        else
        {
          if(is_dir($strDir.$strFile))
          {
            $Files = getFilesInProject($strDir.$strFile.'/', $Files);
          }
        }
      }
    }
    $oDir->close();
  }
  elseif (is_file($strDir))
  {
    if (stristr($strDir, $fileType)!==FALSE) $Files[] = $strDir;
  }
  else
  {
    echo 'ERROR: '.$strDir.' not found!<br />';
  }
  return $Files;
}